//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LAYOUTTYPES_H)
    #define CANDERA_LAYOUTTYPES_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/DynamicProperties/TypeInfo.h>

#define ENUM_DATA_TYPE_NAMESPACE LayoutAlignment
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(StretchBehavior) \
        ENUM_DATA_TYPE_ITEM(None) \
        ENUM_DATA_TYPE_ITEM(Fill) \
        ENUM_DATA_TYPE_ITEM(Uniform) \
        ENUM_DATA_TYPE_ITEM(UniformToFill) \
    ENUM_DATA_TYPE_END(StretchBehavior)
#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE_NAMESPACE LayoutAlignment
#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(LayoutDirection) \
        ENUM_DATA_TYPE_ITEM(LeftToRightDirection) \
        ENUM_DATA_TYPE_ITEM(RightToLeftDirection) \
        ENUM_DATA_TYPE_ITEM(AutomaticDirection) \
        ENUM_DATA_TYPE_ITEM(InheritDirection) \
        ENUM_DATA_TYPE_ITEM(CultureDirection) \
   ENUM_DATA_TYPE_END(LayoutDirection)
#include <Candera/System/MetaInfo/EnumDataType.h>

namespace Candera {


#ifdef CGI_DOXYGEN
    namespace LayoutAlignment {
        namespace LayoutDirection {
            
            /// @addtogroup Layout
            /// @{
            /// @brief Defines the layout direction which is either fixed left-to-right / right-to-left or, in automatic mode, dependent on the system language.
            /**
            * Enum Type
            */
            enum Enum {
                LeftToRightDirection,   ///< Layout is done left-to-right, independent of the current locale setting.
                RightToLeftDirection,   ///< Layout is done right-to-left, independent of the current locale setting.
                AutomaticDirection,     ///< Layout is done dependent of the current locale setting (e.g. right-to-left for Arabic language).
                InheritDirection,       ///< Layout is taken from the parent layout direction.
                CultureDirection        ///< Layout is done dependent of the current locale setting independent of parent layout direction.
            };
            /// @}
        }
        namespace StretchBehavior {
        
            /// @addtogroup Layout
            /// @{            
            /// @brief StretchBehavior defines how e.g. an image is stretched / shrunken if the available area given by a layouter is larger /smaller
            /// than the native image dimensions.
            /**
            * Enum Type
            */
            enum Enum {
                None,           ///< The image will not be stretched; it will be rendered in its original size. If the available space is smaller, it will be clipped.
                Fill,           ///< The image will be stretched (or it shrinks) to fill exactly the available space.
                Uniform,        ///< The original aspect ratio of the image will not be changed, but all of the image will be shown. Therefore the image might not fill the whole width or height of the available space.
                UniformToFill   ///< The original aspect ratio of the image will not be changed, but the whole available space will be filled. Therefore the image might be cut off on the right or bottom side.
            };
            /// @}
        }
    }
    CANDERA_INTERNAL_ENUM_METAINFO_BEGIN(::CgiStudioControl::StretchBehavior::Enum, StretchBehavior)
        CANDERA_INTERNAL_ENUM_METAINFO_ITEM(None)
        CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Fill)
        CANDERA_INTERNAL_ENUM_METAINFO_ITEM(Uniform)
        CANDERA_INTERNAL_ENUM_METAINFO_ITEM(UniformToFill)
    CANDERA_INTERNAL_ENUM_METAINFO_END()
#endif

  //CANDERA_DEPRECATED_3_2_1("Please use the enum with the same name in the LayoutAlignment namespace!", typedef Int32 StretchBehavior);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 None = LayoutAlignment::StretchBehavior::None);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 Fill = LayoutAlignment::StretchBehavior::Fill);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 Uniform = LayoutAlignment::StretchBehavior::Uniform);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 UniformToFill = LayoutAlignment::StretchBehavior::UniformToFill);

  //  CANDERA_DEPRECATED_3_2_1("Please use the enum with the same name in the LayoutAlignment namespace!", typedef Int32 LayoutDirection);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 LeftToRightDirection = LayoutAlignment::LayoutDirection::LeftToRightDirection);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 RightToLeftDirection = LayoutAlignment::LayoutDirection::RightToLeftDirection);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 AutomaticDirection = LayoutAlignment::LayoutDirection::AutomaticDirection);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 InheritDirection = LayoutAlignment::LayoutDirection::InheritDirection);
  //  CANDERA_DEPRECATED_CONST_3_2_1("Please use the value from the LayoutAlignment namespace", static const Int32 CultureDirection = LayoutAlignment::LayoutDirection::CultureDirection);

}   // namespace Candera

CdaDefPrimitiveTypeInfo(LayoutAlignment::StretchBehavior::Enum, LayoutAlignment::StretchBehavior::None)
CdaDefPrimitiveTypeInfo(LayoutAlignment::LayoutDirection::Enum, LayoutAlignment::LayoutDirection::AutomaticDirection)

#endif  // CANDERA_LAYOUTTYPES_H
