//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEFAULTLAYOUTER_H)
    #define CANDERA_DEFAULTLAYOUTER_H

#include <Candera/EngineBase/Layout/Layouter.h>

namespace Candera {

/** @addtogroup Layout
 *  @{
 */

    /**
     *  @brief DefaultLayouter is one static instance used by all 2D nodes by default.
     *  This allows all nodes to get layout without the need of adding a specialized layouter.
     */
    class DefaultLayouter : public Layouter {
        public:
            virtual ~DefaultLayouter() override;

            /**
             *  Gets the instance of this class.
             *  @return A pointer to the instance of this class.
             */
            static DefaultLayouter* GetInstance();

            /**
             *  This is a singleton so dispose does nothing.
             */
            virtual void Dispose() override {}

            // overrides Layouter::Clone
            virtual Layouter* Clone() const override { return GetInstance(); }

        protected:
            DefaultLayouter();
            DefaultLayouter(const DefaultLayouter&);

            virtual Vector2 OnMeasure(const AbstractNodePointer& node, const Vector2& clientArea) override;
            virtual void OnArrange(const AbstractNodePointer& node, const Rectangle& clientArea) override;
            virtual void OnLimitPreferredSize(CanderaObject& node, Vector2& preferredSize, const Vector2& nodeSize, const Vector2& nodeMinSize, const Vector2& nodeMaxSize) override;
            virtual bool IsHandlingScale()
            {
                return true;
            }

        private:

            Vector2 GetScale(const AbstractNodePointer& node, const Vector2& clientSize, const Vector2& preferredSize) const;
    };

 /** @} */ // end of Layout
 
}   // namespace Candera

#endif  // CANDERA_DEFAULTLAYOUTER_H
