//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BOUNDINGRECTTRAVERSER_H)
#define CANDERA_BOUNDINGRECTTRAVERSER_H
#include <CanderaConfig.h>

#ifdef CANDERA_2D_ENABLED
#include <Candera/Engine2D/Core/TreeTraverser2D.h>
#endif

namespace Candera {

/** @addtogroup Core2D
 *  @{
 */
#ifdef CANDERA_2D_ENABLED

    /**
     * @brief   The class BoundingRectTraverser process all child nodes and computes the 
     *          enclosing boundingRectangle.
     */
    class BoundingRectTraverser : public ConstTreeTraverser2D {
        public:
            BoundingRectTraverser(const Node2D& root);
        
            void GetBoundingRectangle(Rectangle& rect) const;
        
        protected:
            virtual TraverserAction ProcessNode(const Node2D& node) override;
        
        private:
            struct Bounds
            {
                Float minX;
                Float minY;
                Float maxX;
                Float maxY;
            };
            bool m_initializedBounds;
            bool m_initializedFallbackPosition;
            Vector2 m_fallbackPosition;
            Bounds m_bounds;
            const Node2D& m_root;
        
            //Forbid assignment, make it private
            BoundingRectTraverser& operator=(const BoundingRectTraverser&);
    };
#endif

}   // namespace Candera

#endif  // CANDERA_BOUNDINGRECTTRAVERSER_H
