//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DynamicProperties_ValueNodeBase_H)
#define CANDERA_DynamicProperties_ValueNodeBase_H

#include <Candera/Environment.h>

namespace Candera { namespace DynamicProperties {
class DynamicPropertyBase;

/**
    * @brief Base class for all value nodes. A value node represents a value of a property and is
    *        attached to a DynamicPropertyHost. Values  of a DynamicPropertyHost are chained in a
    *        single linked list.
    */
class ValueNodeBase {
    public:
        /**
            *  Retrieves the property whose value is represented by this value node.
            *  @return The property whose value is represented by this value node.
            */
        DynamicPropertyBase* OwningProperty() const {
            return m_owningProperty;
        }

        /**
            *  Sets the property whose value is represented by this value node.
            *  @param value   The property whose value shall be represented by this value node.
            */
        void SetOwningProperty(DynamicPropertyBase *value) {
            m_owningProperty = value;
        }

        /**
            *  Retrieves the next value node in the list of value nodes.
            *  @return The next value node in the list of value nodes, if present, 0 otherwise.
            */
        ValueNodeBase* Next() const {
            return m_next;
        }

        /**
            *  Sets the next value node in the list of value nodes.
            *  @param value The next value node in the list of value nodes.
            */
        void SetNext(ValueNodeBase *value) {
            m_next = value;
        }

    protected:

        /**
            *  Initialization.
            *  Intentionally protected to prevent usage without an allocator.
            *  @param owningProperty The property whose value is represented by this value node.
            */
        ValueNodeBase(DynamicPropertyBase *owningProperty) {
            m_owningProperty = owningProperty;
            m_next = 0;
        }

    private:
        DynamicPropertyBase *m_owningProperty;
        ValueNodeBase *m_next;

        FEATSTD_MAKE_CLASS_UNCOPYABLE(ValueNodeBase);
};
}}

#endif    // !defined(CANDERA_DynamicProperties_ValueNode_H)
