//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CANDERAOBJECTDATATYPEBASE_H)
#define CANDERA_CANDERAOBJECTDATATYPEBASE_H

#include <Candera/System/MetaInfo/DataType.h>

namespace Candera {
    class CanderaObject;
    namespace MetaInfo {
        namespace Internal {
            /**
             * @brief AssetLoaderConverterToString for objects that are not CanderaObjects.
             */
            struct NonCanderaObjectBaseConverterToString {
            protected:
                /**
                 * Retrieve an empty string.
                 *
                 * @param       ptr Pointer to the object.
                 * @param [out] buf The string representation (empty string).
                 * @param       bufLen Buffer length.
                 * @return true if ptr points to 0, in which case the empty string representation is correct.
                 */
                static bool ConvertToString(const void* ptr, Char *buf, UInt bufLen);
            };

            /**
             * @brief AssetLoaderConverterToString specialization for CanderaObjects.
             */
            struct CanderaObjectBaseConverterToString {
            protected:
                /**
                 * Retrieve the name of the CanderaObject.
                 *
                 * @param       ptr Pointer to the object.
                 * @param [out] buf The string representation (object name).
                 * @param       bufLen Buffer length.
                 * @return true if ptr points to 0, in which case the empty string representation is correct.
                 */
                static bool ConvertToString(const CanderaObject* ptr, Char *buf, UInt bufLen);
            };
        }
    }
}
#endif // CANDERA_CANDERAOBJECTDATATYPEBASE_H
