//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_RESOURCEDATA_H)
#define CANDERA_RESOURCEDATA_H

#include <Candera/Environment.h>

namespace Candera {

    struct ResourceDataHandle;

    namespace Internal {


        /**
         * ResourceData provides access to data of ResourceDataHandle objects.
         * @see ResourceObject, which is a wrapper over ResourceData, documentation for more details.
         */
        class ResourceData {
            friend bool operator == (const ResourceData& left, const ResourceData& right);
            public:
                explicit ResourceData(ResourceDataHandle& handle);
                explicit ResourceData(const ResourceDataHandle& handle);
                ResourceData(const ResourceData& other);
                ~ResourceData();
                void* GetMutableData();
                const void* GetData() const;
                static SizeType CopyData(void* buffer, const ResourceDataHandle& handle, OffsetType offset, SizeType count);
                static const void* GetAddress(const ResourceDataHandle& handle);
                bool IsPersistent() const;
                ResourceData& operator=(const ResourceData& other);
            private:
                const void* m_data;
                bool m_isPersistent : 1;
                bool m_isMutable : 1;
        };

        inline void* ResourceData::GetMutableData()
        {
            FEATSTD_LINT_NEXT_EXPRESSION(925, "safe cast")
            return (m_isMutable == 1) ? const_cast<void*>(m_data) : 0;
        }

        inline const void* ResourceData::GetData() const
        {
            return m_data;
        }

        inline bool ResourceData::IsPersistent() const
        {
            return (m_isPersistent == 1);
        }

        inline bool operator==(const ResourceData& left, const ResourceData& right)
        {
            return (left.m_data == right.m_data) && (left.m_isMutable == right.m_isMutable) && (left.m_isPersistent == right.m_isPersistent);
        }
    }
} // namespace Candera

#endif  // CANDERA_RESOURCEDATA_H
