// ########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
// ########################################################################
#ifndef CANDERA_NotifyPropertyChangedEvent_h
#define CANDERA_NotifyPropertyChangedEvent_h

#include <FeatStd/Event/Event.h>

namespace Candera {
    class CanderaObject;
    /** @addtogroup CommonBase
    *  @{
    */
    /**
    * NotifyPropertyChangedEvent is an event which is being sent as soon as a public property/state changes. 
    * If the reference holders of a complex object have to update themselves,
    * they can listen to this event as long as the complex object supports this feature.
    * The complex object can send this event by all relevant internal changes of this object.
    * The class Candera::NotifyPropertyChangedInterface provides an interface of functions which can be implemented by this complex object.
    * The object which wants to listen to this event requires a FeatStd::EventListener which can receive this event.
    * The event can hold a weak reference to a Candera::CanderaObject.
    * This CanderaObject represents the complex object which has changes in it and sends the event.
    */
    class NotifyPropertyChangedEvent : public FeatStd::Event {
    public:
        FEATSTD_TYPEDEF_BASE(FeatStd::Event);
        FEATSTD_RTTI_DECLARATION();

        /**
        * The constructor of the event.
        * @param baseObject represents the object which generates the event.
        */
        NotifyPropertyChangedEvent(CanderaObject * baseObject = 0);

        /**
        * The destructor of the event.
        */
        virtual ~NotifyPropertyChangedEvent();

        /**
        * The constructor of the event.
        * @return a Candera::CanderaObject which produced the event.
        */
        CanderaObject * GetBaseObject() const;

    private:
        CanderaObject* m_baseObject;
        FEATSTD_MAKE_CLASS_UNCOPYABLE(NotifyPropertyChangedEvent);
    };
    /// @}

}

#endif // CANDERA_NotifyPropertyChangedEvent_h
