//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "CameraGroup.h"

#ifdef CANDERA_2D_ENABLED
#include <Candera/Engine2D/Core/Camera2D.h>
#endif
#ifdef CANDERA_3D_ENABLED
#include <Candera/Engine3D/Core/Camera.h>
#endif

namespace Candera {
#ifdef CANDERA_3D_ENABLED

    void CameraGroup::AddCamera(Camera* camera)
    {
        static_cast<void>(m_camera3DList.Add(camera));
    }

    void CameraGroup::RemoveCamera(Int index)
    {
        static_cast<void>(m_camera3DList.Remove(index));
    }

    void CameraGroup::ClearCameraList()
    {
        m_camera3DList.Clear();
    }

    SizeType CameraGroup::GetCameraCount() const
    {
        return m_camera3DList.Size();
    }

    Camera* Candera::CameraGroup::GetCamera(Int index)
    {
        if ((index < 0) || (index >= static_cast<Int>(m_camera3DList.Size()))) {
            return 0;
        }

        return m_camera3DList[index];
    }

    const Camera* Candera::CameraGroup::GetCamera(Int index) const
    {
        if ((index < 0) || (index >= static_cast<Int>(m_camera3DList.Size()))) {
            return 0;
        }

        return m_camera3DList[index];
    }

#endif

#ifdef CANDERA_2D_ENABLED
    void CameraGroup::AddCamera2D(Camera2D* camera)
    {
        static_cast<void>(m_camera2DList.Add(camera));
    }

    void CameraGroup::RemoveCamera2D(Int index)
    {
        static_cast<void>(m_camera2DList.Remove(index));
    }

    void CameraGroup::ClearCamera2DList()
    {
        m_camera2DList.Clear();
    }

    SizeType CameraGroup::GetCamera2DCount() const
    {
        return m_camera2DList.Size();
    }

    Camera2D* Candera::CameraGroup::GetCamera2D(Int index)
    {
        if ((index < 0) || (index >= static_cast<Int>(m_camera2DList.Size()))) {
            return 0;
        }

        return m_camera2DList[index];
    }

    const Camera2D* Candera::CameraGroup::GetCamera2D(Int index) const
    {
        if ((index < 0) || (index >= static_cast<Int>(m_camera2DList.Size()))) {
            return 0;
        }

        return m_camera2DList[index];
    }

#endif

    void CameraGroup::SetRenderingEnabled(bool renderingEnabled)
    {
#ifdef CANDERA_2D_ENABLED
        for (Int cameraIndex = 0; cameraIndex < static_cast<Int>(m_camera2DList.Size()); ++cameraIndex) {
            Camera2D* camera = m_camera2DList[cameraIndex];
            if (camera != 0) {
                camera->SetRenderingEnabled(renderingEnabled);
            }
        }
#endif
#ifdef CANDERA_3D_ENABLED
        for (Int cameraIndex = 0; cameraIndex < static_cast<Int>(m_camera3DList.Size()); ++cameraIndex) {
            Camera* camera = m_camera3DList[cameraIndex];
            if (camera != 0) {
                camera->SetRenderingEnabled(renderingEnabled);
            }
        }
#endif
    }

}
