//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitmapGlyphCacheAccess.h"

#include <Candera/System/Diagnostics/Log.h>
#include <CanderaPlatform/OS/MemoryPlatform.h>
#include <FeatStd/Util/StaticObject.h>
#include <Candera/TextEngine/Internal/CacheAccessType.h>

namespace Candera
{

FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaEngine3D);

BitmapGlyphCacheAccess& BitmapGlyphCacheAccess::GetInstance()
{
    FEATSTD_SYNCED_STATIC_OBJECT(BitmapGlyphCacheAccess, s_instance);
    return s_instance;
}

BitmapGlyphCacheAccess::BitmapGlyphCacheAccess()
{
}

BitmapGlyphCacheAccess::~BitmapGlyphCacheAccess()
{
    ReleaseCache();
}

UInt8* BitmapGlyphCacheAccess::Create(const TextRendering::GlyphBitmap& bitmap, UInt8* cacheItem)
{
    if (0 != cacheItem) {
        return cacheItem;
    }

    UInt8* bitmapData = 0;
    if (0 != bitmap.pixels) {
        const SizeType bitmapSize = static_cast<SizeType>(bitmap.width * bitmap.height);
        bitmapData = CANDERA_NEW_ARRAY(UInt8, bitmapSize);
        if (0 != bitmapData) {
            MemoryPlatform::Copy(bitmapData, bitmap.pixels, bitmapSize);
        }
    }
    else {
        bitmapData = CANDERA_NEW_ARRAY(UInt8, 1);
    }

    return bitmapData;
}

bool BitmapGlyphCacheAccess::CheckCacheItem(TextRendering::PixelBuffer buffer)
{
    const UInt8* bitmapData = FeatStd::Internal::PointerToPointer<const UInt8*>(buffer);
    return (bitmapData != 0);
}

void BitmapGlyphCacheAccess::DestroyCacheItem(TextRendering::PixelBuffer buffer)
{
    CANDERA_DELETE_ARRAY(FeatStd::Internal::PointerToPointer<const UInt8*>(buffer));
}


Candera::TextRendering::Internal::CacheAccessType::Enum BitmapGlyphCacheAccess::GetCacheAccessType() const
{
    return TextRendering::Internal::CacheAccessType::Bitmap;
}

}
