//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BaseStringBufferAppenders_H)
    #define CANDERA_BaseStringBufferAppenders_H

#include <Candera/System/MetaInfo/DataTypeStringBufferAppenderMacros.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>

namespace Candera {
    class Bitmap;
    class ImageSource2D;
    class ImageSource3D;
    class RenderTarget2D;
    class RenderTarget3D;
    class SharedClearMode;
    class SharedClearMode2D;
    class WidgetBase;
    class CameraGroup;
    class GraphicDeviceUnit;
    class Color;

    namespace Animation {
        class AnimationPlayerBase;
        class AnimationPlayer;
        class AnimationGroupPlayer;
    }

    namespace TextRendering {
        class SharedStyle;
    }
}

CdaDeclareStringBufferAppender(FeatStd::MemoryManagement::SharedPointer<Candera::TextRendering::SharedStyle> )
CdaDeclareStringBufferAppender(FeatStd::MemoryManagement::SharedPointer<Candera::Bitmap> )
CdaDeclareStringBufferAppender(Candera::WidgetBase*)
CdaDeclareStringBufferAppender(Candera::CameraGroup*)
CdaDeclareStringBufferAppender(Candera::GraphicDeviceUnit*)
CdaDeclareStringBufferAppender(FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayerBase> )
CdaDeclareStringBufferAppender(FeatStd::MemoryManagement::SharedPointer<Candera::SharedClearMode> )
CdaDeclareStringBufferAppender(FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationPlayer> )
CdaDeclareStringBufferAppender(FeatStd::MemoryManagement::SharedPointer<Candera::Animation::AnimationGroupPlayer> )
CdaDeclareStringBufferAppender(Candera::ImageSource3D* )
CdaDeclareStringBufferAppender(Candera::ImageSource2D* )
CdaDeclareStringBufferAppender(Candera::RenderTarget3D* )
CdaDeclareStringBufferAppender(Candera::RenderTarget2D* )
CdaDeclareStringBufferAppender(Candera::Color)

#endif  // CANDERA_BaseStringBufferAppenders_H
