//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ENGINEBASE_COMMON_ALIGNMENT_H)
#define CANDERA_ENGINEBASE_COMMON_ALIGNMENT_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/DynamicProperties/TypeInfo.h>
#include <Candera/System/MetaInfo/DataTypeStringBufferAppenderMacros.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(HorizontalAlignment)   \
        ENUM_DATA_TYPE_ITEM(HLeft)              \
        ENUM_DATA_TYPE_ITEM(HCenter)            \
        ENUM_DATA_TYPE_ITEM(HRight)             \
        ENUM_DATA_TYPE_ITEM(HStretch)           \
    ENUM_DATA_TYPE_END(HorizontalAlignment)

#include <Candera/System/MetaInfo/EnumDataType.h>

#define ENUM_DATA_TYPE \
    ENUM_DATA_TYPE_BEGIN(VerticalAlignment)     \
        ENUM_DATA_TYPE_ITEM(VTop)               \
        ENUM_DATA_TYPE_ITEM(VCenter)            \
        ENUM_DATA_TYPE_ITEM(VBottom)            \
        ENUM_DATA_TYPE_ITEM(VStretch)           \
    ENUM_DATA_TYPE_END(VerticalAlignment)

#include <Candera/System/MetaInfo/EnumDataType.h>

CdaDefPrimitiveTypeInfo(HorizontalAlignment, HStretch)
CdaDefPrimitiveTypeInfo(VerticalAlignment, VStretch)

CdaDeclareStringBufferAppender(Candera::HorizontalAlignment)
CdaDeclareStringBufferAppender(Candera::VerticalAlignment)

namespace Candera {

    /** @addtogroup CommonBase
     *  @{
     */

    /**
     *  \enum Candera::HorizontalAlignment
     *  HorizontalAlignment defines the horizontal position of an item within a given area (e.g. by a layouter).
     *
     *  \var Candera::HorizontalAlignment Candera::HLeft
     *  The item is placed on the left edge within the given area.
     *
     *  \var Candera::HorizontalAlignment Candera::HCenter
     *  The item is horizontally centered within the given area.
     *
     *  \var Candera::HorizontalAlignment Candera::HRight
     *  The item is placed on the right edge within the given area.
     *
     *  \var Candera::HorizontalAlignment Candera::HStretch
     *  The whole available width is passed to the item's layouter which has to decide how to align the item horizontally.
     */

    /**
     *  \enum Candera::VerticalAlignment
     *  VerticalAlignment defines the vertical position of an item within a given area (e.g. by a layouter).
     *
     *  \var Candera::VerticalAlignment Candera::VTop
     *  The item is placed on the top edge within the given area.
     *
     *  \var Candera::VerticalAlignment Candera::VCenter
     *  The item is vertically centered within the given area.
     *
     *  \var Candera::VerticalAlignment Candera::VBottom
     *  The item is placed on the bottom edge within the given area.
     *
     *  \var Candera::VerticalAlignment Candera::VStretch
     *  The whole available height is passed to the item's layouter which has to decide how to align the item horizontally.
     */

    /** @} */


}   // namespace Candera

#endif  // CANDERA_ENGINEBASE_COMMON_ALIGNMENT_H
