//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_EaseFunctions_H)
#define CANDERA_EaseFunctions_H

#include <Candera/EngineBase/Animation/AbstractEasingFunction.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

    /**
     * @brief PowerEaseFunction implements an animation ease function that starts at 0.0F and grows to 1.0F with
     *  the formula f(x) = x^power, where power is configurable.
     */
    class PowerEaseFunction : public AbstractEasingFunction {
        FEATSTD_TYPEDEF_BASE(AbstractEasingFunction);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(PowerEaseFunction);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Constructor
             */
            PowerEaseFunction();

            /**
             *  Destructor
             */
            virtual ~PowerEaseFunction() override;

            /**
             *  Function solve method.
             *  @param inValue  Function inValue argument.
             *  @return computed output of function for given argument.
             */
            virtual Float Resolve(Float inValue) const override;

            /**
             *  Set exponential power of interpolation.
             *  For example, a value of 2 will create an interpolation curve that follows the equation f(t) = t^2.
             *  @param power  The exponential power (must be greater than 0).
             */
            void SetPower(UInt8 power);

            /**
             *  Get the exponential power of interpolation.
             *  @return exponential power.
             */
            UInt8 GetPower() const;

            FEATSTD_RTTI_DECLARATION();

        private:
            UInt8 m_power;
    };

 /** @} */ // end of AnimationBase

    } // namespace Animation
} // namespace Candera

#endif
