//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LinearInterpolationStrategy_H)
#define CANDERA_LinearInterpolationStrategy_H

#include <Candera/EngineBase/Animation/InterpolationStrategy.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

    /**
     * @brief InterpolationStrategy implementation.
     *
     * This interpolation strategy produces a linear transition between keyframe values.
     * Each interpolated value is a weighted average of the keyframes placed just before
     * and after the given sequence time.
     */
    class LinearInterpolationStrategy: public InterpolationStrategy {

        FEATSTD_TYPEDEF_BASE(InterpolationStrategy);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(LinearInterpolationStrategy);

            FEATSTD_RTTI_DECLARATION();

            /**
             *  Creates a StepInterpolationStrategy object.
             *  @return Pointer to the created LinearInterpolationStrategy object.
             */
            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Destructs an StepInterpolationStrategy object.
             */
            virtual ~LinearInterpolationStrategy() override {}

            /**
             *  Calculate the interpolated value of a KeyframeSequence at a given sequence time.
             *  @param keyframeSequence    The sequence of keyframes the interpolation strategy should be applied on.
             *  @param sequenceTime        The time at which the interpolated value should be calculated.
             *  @param resultValue [out]   The resulted interpolated value.
             */
            virtual void Interpolate(
                const KeyframeSequence* keyframeSequence,
                SequenceTimeType sequenceTime,
                Float* resultValue) const override;

        protected:
            LinearInterpolationStrategy() {}

    };

 /** @} */ // end of AnimationBase

    } // namespace Animation
} // namespace Candera

#endif
