//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_LayoutMarginsPropertySetter_H)
#define CANDERA_LayoutMarginsPropertySetter_H

#include <Candera/EngineBase/Animation/AbstractNodePropertySetter.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationPropertySetters2D
 *  @{
 */

    /** 
     * @brief A PropertySetter that sets the "Margin" property used for layouting the associated Node2D.
     */
    class LayoutMarginsPropertySetter : public AbstractNodePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(LayoutMarginsPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
         * Sets the "Margin" property used for layout the associated Node2.
         *
         * @param value - pointer to an array of 4 float values for the Margin.
         */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(LayoutMarginsPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Left" value for the "Margin" property used for layouting the associated Node2D.
    */
    class LayoutMarginsLeftPropertySetter : public AbstractNodePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(LayoutMarginsLeftPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Left" value for the "Margin" property used for layout the associated Node2.
        *
        * @param value - Left value for Margin.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(LayoutMarginsLeftPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Top" value for the "Margin" property used for layouting the associated Node2D.
    */
    class LayoutMarginsTopPropertySetter : public AbstractNodePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(LayoutMarginsTopPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Top" value for the "Margin" property used for layout the associated Node2.
        *
        * @param value - Top value for Margin.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(LayoutMarginsTopPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Right" value for the "Margin" property used for layouting the associated Node2D.
    */
    class LayoutMarginsRightPropertySetter : public AbstractNodePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(LayoutMarginsRightPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Right" value for the "Margin" property used for layout the associated Node2.
        *
        * @param value - Right value for the Margin.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(LayoutMarginsRightPropertySetter);
    };

    /**
    * @brief A PropertySetter that sets the "Bottom" value for the "Margin" property used for layouting the associated Node2D.
    */
    class LayoutMarginsBottomPropertySetter : public AbstractNodePropertySetter {
    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(LayoutMarginsBottomPropertySetter);

        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        FEATSTD_RTTI_DECLARATION();

        /**
        * Sets the "Bottom" value for the "Margin" property used for layout the associated Node2.
        *
        * @param value - Bottom value for the Margin.
        */
        virtual void Set(const Float* value) override;

    private:
        FEATSTD_TYPEDEF_BASE(LayoutMarginsBottomPropertySetter);
    };

 /** @} */ // end of AnimationPropertySetters2D
    }   // namespace Animation

}   // namespace Candera

#endif  // CANDERA_LayoutMarginsPropertySetter_H
