//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "LayoutMarginsPropertySetter.h"
#include <Candera/Engine2D/Core/Node2D.h>
#include <Candera/EngineBase/Layout/Margin.h>
#include <Candera/EngineBase/Layout/Layouter.h>

namespace Candera { namespace Animation {

    FEATSTD_RTTI_DEFINITION(LayoutMarginsPropertySetter, AbstractNodePropertySetter)
    FEATSTD_RTTI_DEFINITION(LayoutMarginsLeftPropertySetter, AbstractNodePropertySetter)
    FEATSTD_RTTI_DEFINITION(LayoutMarginsTopPropertySetter, AbstractNodePropertySetter)
    FEATSTD_RTTI_DEFINITION(LayoutMarginsRightPropertySetter, AbstractNodePropertySetter)
    FEATSTD_RTTI_DEFINITION(LayoutMarginsBottomPropertySetter, AbstractNodePropertySetter)

    /******************************************************************************
    *  LayoutMarginsPropertySetter method definitions
    ******************************************************************************/
    void LayoutMarginsPropertySetter::Set(const Float* value)
    {
        AbstractNodePointer& node = GetNode();
        if ((0 == value) || (!node.IsValid())) {
            return;
        }

        Layouter* layouter = node.GetLayouter();
        if (0 != layouter) {
            layouter->SetMargin(*node.ToCanderaObject(), Margin(static_cast<Int16>(value[0]), static_cast<Int16>(value[1]), static_cast<Int16>(value[2]), static_cast<Int16>(value[3])));
        }
    }
    
    LayoutMarginsPropertySetter::SharedPointer LayoutMarginsPropertySetter::Create()
    {
        return LayoutMarginsPropertySetter::SharedPointer(CANDERA_NEW(LayoutMarginsPropertySetter));
    }

    /******************************************************************************
    *  LayoutMarginsLeftPropertySetter method definitions
    ******************************************************************************/
    void LayoutMarginsLeftPropertySetter::Set(const Float* value)
    {
        AbstractNodePointer& node = GetNode();
        if ((0 == value) || (!node.IsValid())) {
            return;
        }

        Layouter* layouter = node.GetLayouter();
        if (0 != layouter) {
            Margin margin = layouter->GetMargin(*node.ToCanderaObject());
            layouter->SetMargin(*node.ToCanderaObject(), Margin(static_cast<Int16>(*value), margin.GetTop(), margin.GetRight(), margin.GetBottom()));
        }
    }

    LayoutMarginsLeftPropertySetter::SharedPointer LayoutMarginsLeftPropertySetter::Create()
    {
        return LayoutMarginsLeftPropertySetter::SharedPointer(CANDERA_NEW(LayoutMarginsLeftPropertySetter));
    }

    /******************************************************************************
    *  LayoutMarginsTopPropertySetter method definitions
    ******************************************************************************/
    void LayoutMarginsTopPropertySetter::Set(const Float* value)
    {
        AbstractNodePointer& node = GetNode();
        if ((0 == value) || (!node.IsValid())) {
            return;
        }

        Layouter* layouter = node.GetLayouter();
        if (0 != layouter) {
            Margin margin = layouter->GetMargin(*node.ToCanderaObject());
            layouter->SetMargin(*node.ToCanderaObject(), Margin(margin.GetLeft(), static_cast<Int16>(*value), margin.GetRight(), margin.GetBottom()));
        }
    }

    LayoutMarginsTopPropertySetter::SharedPointer LayoutMarginsTopPropertySetter::Create()
    {
        return LayoutMarginsTopPropertySetter::SharedPointer(CANDERA_NEW(LayoutMarginsTopPropertySetter));
    }

    /******************************************************************************
    *  LayoutMarginsRightPropertySetter method definitions
    ******************************************************************************/
    void LayoutMarginsRightPropertySetter::Set(const Float* value)
    {
        AbstractNodePointer& node = GetNode();
        if ((0 == value) || (!node.IsValid())) {
            return;
        }

        Layouter* layouter = node.GetLayouter();
        if (0 != layouter) {
            Margin margin = layouter->GetMargin(*node.ToCanderaObject());
            layouter->SetMargin(*node.ToCanderaObject(), Margin(margin.GetLeft(), margin.GetTop(), static_cast<Int16>(*value), margin.GetBottom()));
        }
    }

    LayoutMarginsRightPropertySetter::SharedPointer LayoutMarginsRightPropertySetter::Create()
    {
        return LayoutMarginsRightPropertySetter::SharedPointer(CANDERA_NEW(LayoutMarginsRightPropertySetter));
    }

    /******************************************************************************
    *  LayoutMarginsBottomPropertySetter method definitions
    ******************************************************************************/
    void LayoutMarginsBottomPropertySetter::Set(const Float* value)
    {
        AbstractNodePointer& node = GetNode();
        if ((0 == value) || (!node.IsValid())) {
            return;
        }

        Layouter* layouter = node.GetLayouter();
        if (0 != layouter) {
            Margin margin = layouter->GetMargin(*node.ToCanderaObject());
            layouter->SetMargin(*node.ToCanderaObject(), Margin(margin.GetLeft(), margin.GetTop(), margin.GetRight(), static_cast<Int16>(*value)));
        }
    }

    LayoutMarginsBottomPropertySetter::SharedPointer LayoutMarginsBottomPropertySetter::Create()
    {
        return LayoutMarginsBottomPropertySetter::SharedPointer(CANDERA_NEW(LayoutMarginsBottomPropertySetter));
    }

}}  // namespace Candera { namespace Animation {
