//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_InterpolationStrategy_H)
#define CANDERA_InterpolationStrategy_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/Animation/AnimationTimeType.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <Candera/System/Rtti/Rtti.h>

namespace Candera { namespace Animation {
/** @addtogroup AnimationBase
 *  @{
 */

    class KeyframeSequence;

    /**
     * @brief InterpolationStrategy provides an interface for calculating the interpolated
     * value of a KeyframeSequence at a given sequence time.
     */
    class InterpolationStrategy
    {
        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(InterpolationStrategy);

            /**
             * Constructor.
             */
            InterpolationStrategy() {}

            /**
             * Destructor.
             */
            virtual ~InterpolationStrategy() {}

            /**
             * Calculate the interpolated value of a KeyframeSequence at a given sequence time.
             *
             * @param keyframeSequence              The sequence of keyframes the interpolation strategy should be applied on.
             * @param sequenceTime                  The time at which the interpolated value should be calculated.
             * @param resultValue [out]             The resulted interpolated value.
             */
            virtual void Interpolate(const KeyframeSequence* keyframeSequence, SequenceTimeType sequenceTime, Float* resultValue) const = 0;


            FEATSTD_RTTI_DECLARATION();
            CANDERA_SHARED_POINTER_DECLARATION();
    };

 /** @} */ // end of AnimationBase

    } // namespace Animation
} // namespace Candera

#endif
