//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ExponentialFunction_H)
#define CANDERA_ExponentialFunction_H

#include <Candera/EngineBase/Animation/AbstractEasingFunction.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

    /**
     * @brief ExponentialEaseFunction implements an animation ease function that starts at 0.0F and grows exponentially
     *  until it reaches value 1.0F.
     */
    class ExponentialEaseFunction : public AbstractEasingFunction {
        FEATSTD_TYPEDEF_BASE(AbstractEasingFunction);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(ExponentialEaseFunction);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

            /**
             *  Constructor
             */
            ExponentialEaseFunction();
            
            /**
             *  Destructor
             */
            virtual ~ExponentialEaseFunction() override;

            /**
             *  Function solve method.
             *  @param inValue  Function inValue argument.
             *  @return computed output of function for given argument.
             */
            virtual Float Resolve(Float inValue) const override;

            /**
             *  Set Exponent.
             *  @param exponent Nonzero float value.
             */
            void SetExponent(Float exponent);

            /**
             *  Get Exponent.
             *  @return exponent.
             */
            Float GetExponent() const;

            FEATSTD_RTTI_DECLARATION();

        private:
            Float m_exponent;
            Float m_oneOverDivisor;
    };

 /** @} */ // end of AnimationBase

    } // namespace Animation
} // namespace Candera

#endif
