//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_ElasticFunction_H)
#define CANDERA_ElasticFunction_H

#include <Candera/EngineBase/Animation/ExponentialEaseFunction.h>

namespace Candera { namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

    /**
     * @brief ElasticEaseFunction implements an animation ease function that starts at 0.0F oscillating around
     * this value with increasing amplitudes until it reaches value 1.0F.
     */
    class ElasticEaseFunction : public ExponentialEaseFunction {
        FEATSTD_TYPEDEF_BASE(ExponentialEaseFunction);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(ElasticEaseFunction);

            FEATSTD_SHARED_POINTER_CREATE_DECLARATION();
            
            /**
             *  Constructor
             */
            ElasticEaseFunction();

            /**
             *  Destructor
             */
            virtual ~ElasticEaseFunction() override;

            /**
             *  Function solve method.
             *  @param inValue  Function inValue argument.
             *  @return computed output of function for given argument.
             */
            virtual Float Resolve(Float inValue) const override;

            /**
             *  Set OscillationCount.
             *  The oscillation count sets the number of oscillations that will be mapped in the [0..1] input interval.
             *  @param oscillationCount Oscillation count.
             */
            void SetOscillationCount(UInt8 oscillationCount);

            /**
             *  Get OscillationCount.
             *  @return oscillation count.
             */
            UInt8 GetOscillationCount() const;

            FEATSTD_RTTI_DECLARATION();

        private:
            UInt8 m_oscillationCount;
    };

 /** @} */ // end of AnimationBase
    } // namespace Animation
} // namespace Candera

#endif
