//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_CameraGroupAnimationPropertySetter_H)
#define CANDERA_CameraGroupAnimationPropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/Macros.h>

namespace Candera {

class CameraGroup;

namespace Animation {

/** @addtogroup AnimationBase
 *  @{
 */

/** @brief A PropertySetter that sets properties of a CameraGroup. This is a base class.*/
class CameraGroupAnimationPropertySetter : public AnimationPropertySetter {

    FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    /**
     *  Constructor
     */
    CameraGroupAnimationPropertySetter();

    /**
     *  Destructor
     */
    virtual ~CameraGroupAnimationPropertySetter() override;

    /**
     *  Assigns a node to the PropertySetter.
     *  @param cameraGroup The node that is assigned.
     */
    void SetCameraGroup(Candera::CameraGroup* cameraGroup) { m_cameraGroup = cameraGroup; }

    /**
     *  Retrieves the current node of the PorpertySetter.
     *  @return The current node.
     */
    CameraGroup* GetCameraGroup() { return m_cameraGroup; }
    const CameraGroup* GetCameraGroup() const { return m_cameraGroup; }

protected:
    CameraGroup* m_cameraGroup;

    FEATSTD_MAKE_CLASS_UNCOPYABLE(CameraGroupAnimationPropertySetter);
};

/** @} */ // end of AnimationBase

}
}
#endif
