//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_AnimationPlayerListener_H)
#define CANDERA_AnimationPlayerListener_H

#include <Candera/Environment.h>

namespace Candera { namespace Animation {
/** @addtogroup AnimationBase
 *  @{
 */
    class AnimationPlayerBase;
   
/**
* @brief    An AnimationPlayerListener defines several hooks for the AnimationPlayer.
*           In order to register an AnimationPlayerListener to an AnimationPlayer simply derive from AnimationPlayerListener and override pure virtual functions with custom code.
*/
class AnimationPlayerListener
{
    public:
        /**
          * Constructs an AnimationPlayerListener object.
          */
        AnimationPlayerListener() {}

        /**
          * Destructs an AnimationPlayerListener object.
          */
        virtual ~AnimationPlayerListener() {}

        /**
          * Is invoked on Past End.
          * @param animationPlayer Animation Player to listen to.
          * @param completedIterationsCount
          */
        virtual void OnPastEnd(AnimationPlayerBase* animationPlayer, Int32 completedIterationsCount);

        /**
          * Is invoked with a started animation.
          * @param animationPlayer Animation Player to listen to.
          */
        virtual void OnStartAnimation(AnimationPlayerBase* animationPlayer);

        /**
          * Is invoked with a stopped animation.
          * @param animationPlayer Animation Player to listen to.
          */
        virtual void OnStopAnimation(AnimationPlayerBase* animationPlayer);

        /**
          * Is invoked with a finished animation.
          * @param animationPlayer Animation Player to listen to.
          */
        virtual void OnFinishAnimation(AnimationPlayerBase* animationPlayer);

        /**
          * Is invoked with a resumed animation.
          * @param animationPlayer Animation Player to listen to.
          */
        virtual void OnResumeAnimation(AnimationPlayerBase* animationPlayer);

        /**
          * Is invoked with a paused animation.
          * @param animationPlayer Animation Player to listen to.
          */
        virtual void OnPauseAnimation(AnimationPlayerBase* animationPlayer);

        /**
          * Is invoked with a changed direction.
          * @param animationPlayer Animation Player to listen to.
          * @param direction Specifies the new animation direction.
          */
        virtual void OnDirectionChange(AnimationPlayerBase* animationPlayer, Int direction);

    protected:
        AnimationPlayerListener(const AnimationPlayerListener&);
        AnimationPlayerListener& operator=(const AnimationPlayerListener&);
};

inline void AnimationPlayerListener::OnPastEnd(AnimationPlayerBase* /*animationPlayer*/, Int32 /*completedIterationsCount*/) {}
inline void AnimationPlayerListener::OnStartAnimation(AnimationPlayerBase* /*animationPlayer*/) {}
inline void AnimationPlayerListener::OnStopAnimation(AnimationPlayerBase* /*animationPlayer*/) {}
inline void AnimationPlayerListener::OnFinishAnimation(AnimationPlayerBase* /*animationPlayer*/) {}
inline void AnimationPlayerListener::OnResumeAnimation(AnimationPlayerBase* /*animationPlayer*/) {}
inline void AnimationPlayerListener::OnPauseAnimation(AnimationPlayerBase* /*animationPlayer*/) {}
inline void AnimationPlayerListener::OnDirectionChange(AnimationPlayerBase* /*animationPlayer*/, Int /*direction*/) {}

/** @} */ // end of AnimationBase

    } // namespace Animation
} // namespace Candera

#endif// CANDERA_AnimationPlayerListener_H

