//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_AbstractNodePropertySetter_H)
#define CANDERA_AbstractNodePropertySetter_H

#include <Candera/EngineBase/Animation/AnimationPropertySetter.h>
#include <Candera/EngineBase/Common/AbstractNodePointer.h>

namespace Candera {

    class AbstractNodePointer;

    namespace Animation {

        /** @addtogroup AnimationBase
        *  @{
        */

        /**
        *  @brief Base class for AbstractNodePointer property setters.
        *  Represents both 2D and 3D nodes in an abstracted manner.
        */
        class AbstractNodePropertySetter : public AnimationPropertySetter {
            FEATSTD_TYPEDEF_BASE(AnimationPropertySetter);

        public:
            FEATSTD_TYPEDEF_SHARED_POINTER(AbstractNodePropertySetter);

            FEATSTD_RTTI_DECLARATION();

            /**
            * Constructor.
            */
            AbstractNodePropertySetter();

            /**
            * Sets the node the property setter operates on.
            * @param node The transformable object.
            */
            void SetNode(Candera::AbstractNodePointer& node) { m_node = node; }
#ifdef CANDERA_2D_ENABLED
            /**
            * Sets the node the property setter operates on.
            * @param node The transformable object.
            */
            void SetNode(Candera::Node2D* node) { m_node = AbstractNodePointer(node); }
#endif
#ifdef CANDERA_3D_ENABLED
            /**
            * Sets the node the property setter operates on.
            * @param node The transformable object.
            */
            void SetNode(Candera::Node* node) { m_node = AbstractNodePointer(node); }
#endif
            /**
            * Gets the node the property setter operates on.
            * @return The node object.
            */
            Candera::AbstractNodePointer& GetNode() { return m_node; }

            const Candera::AbstractNodePointer& GetNode() const { return m_node; }

        private:
            Candera::AbstractNodePointer m_node;
        };

        /** @} */ // end of AnimationPropertySetters
    }// namespace Animation

}// namespace Candera

#endif  // CANDERA_BaseNode2DPropertySetter_H
