//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "VertexGeometryModifier.h"
#include <Candera/Engine3D/Core/VertexGeometry.h>
#include <Candera/Engine3D/Core/VertexGeometryAccessors.h>

namespace Candera {
    VertexGeometryModifier::VertexGeometryModifier(const VertexGeometry& geometry, VertexGeometry::VertexUsage usage, UInt8 usageIndex) :
        m_count(0),
        m_offset(0),
        m_floatConverter(),
        m_intConverter(),
        m_floatConverterInverse(),
        m_intConverterInverse()
    {
        ElementFormatAccessor formatAccessor(geometry);
        const VertexGeometry::VertexElementFormat* element =
            formatAccessor.GetElementFormatByUsageAndIndex(usage, usageIndex);

        if (element != 0) {
            m_offset = element->Offset;

            VertexGeometryTools::DataTypeTraits traits = VertexGeometryTools::GetTypeTraits(element->Type);
            m_count = traits.count;

            m_floatConverter = VertexGeometryTools::GetConverter(traits.type, VertexGeometryTools::Float32Type);
            m_intConverter = VertexGeometryTools::GetConverter(traits.type, VertexGeometryTools::Int32Type);

            m_floatConverterInverse = VertexGeometryTools::GetConverter(VertexGeometryTools::Float32Type, traits.type);
            m_intConverterInverse = VertexGeometryTools::GetConverter(VertexGeometryTools::Int32Type, traits.type);
        }
    }

    void VertexGeometryModifier::SetVertexElement(void *vertex, Float x, Float y, Float z, Float w) const
    {
        Float t[4] = { x, y, z, w };
        SetVertexElement(vertex, t, 4);
    }
    void VertexGeometryModifier::SetVertexElement(void *vertex, const Float *t, UInt8 tSize) const
    {
        m_floatConverter.ConvertItem(FeatStd::Internal::PointerToPointer<UInt8*>(vertex)+m_offset, m_count, t, tSize);
    }
    void VertexGeometryModifier::SetVertexElement(void *vertex, Int x, Int y, Int z, Int w) const
    {
        Int t[4] = { x, y, z, w };
        SetVertexElement(vertex, t, 4);
    }
    void VertexGeometryModifier::SetVertexElement(void *vertex, const Int *t, UInt8 tSize) const
    {
        m_intConverter.ConvertItem(FeatStd::Internal::PointerToPointer<UInt8*>(vertex)+m_offset, m_count, t, tSize);
    }
    void VertexGeometryModifier::GetVertexElement(const void *vertex, Float *t, UInt8 tSize) const
    {
        m_floatConverterInverse.ConvertItem(t, tSize, FeatStd::Internal::PointerToPointer<const UInt8*>(vertex)+m_offset, m_count);
    }
    void VertexGeometryModifier::GetVertexElement(const void *vertex, Int *t, UInt8 tSize) const
    {
        m_intConverterInverse.ConvertItem(t, tSize, FeatStd::Internal::PointerToPointer<const UInt8*>(vertex)+m_offset, m_count);
    }
} // namespace Candera
