//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "UniformBuffer.h"

#include <Candera/Engine3D/Core/Renderer.h>

namespace Candera {

UniformBuffer::UniformBuffer()
    :
    m_isDirty(true)
{
    MemoryPlatform::Set(m_deviceHandle, 0, sizeof(m_deviceHandle));
}

UniformBuffer::~UniformBuffer()
{
    static_cast<void>(Unload(ForceAll));
}

UniformBuffer::UniformBuffer(const UniformBuffer& rhs)
    :
    Base(),
    m_isDirty(rhs.m_isDirty)
{
    MemoryPlatform::Copy(m_deviceHandle, rhs.m_deviceHandle, sizeof(m_deviceHandle));
}

bool UniformBuffer::UploadInternal(LoadingHint loadingHint)
{
    return Renderer::UploadUniformBuffer(*this, loadingHint);
}

bool UniformBuffer::UnloadInternal(LoadingHint loadingHint)
{
    return Renderer::UnloadUniformBuffer(*this, loadingHint);
}

}
