//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ShaderParamNames.h"

#include <FeatStd/Util/Hash.h>

namespace Candera {

const Char* ShaderParamNames::m_uniformNames[] =
{
    "u_MMatrix3",                   // ModelMatrix3
    "u_MVMatrix3",                  // ModelViewMatrix3
    "u_NormalMMatrix3",             // NormalModelMatrix3
    "u_NormalMVMatrix3",            // NormalModelViewMatrix3
    "u_MMatrix",                    // ModelMatrix4
    "u_MVMatrix",                   // ModelViewMatrix4
    "u_PMatrix",                    // ProjectionMatrix4
    "u_MVPMatrix",                  // ModelViewProjectionMatrix4
    "u_CamDirection",               // CameraLookAtVector
    "u_CamPosition",                // CameraPosition
    "u_Size",                       // PointSpriteSize

    "u_Material.ambient",           // MaterialAmbient
    "u_Material.diffuse",           // MaterialDiffuse
    "u_Material.emissive",          // MaterialEmissive
    "u_Material.specular",          // MaterialSpecular
    "u_Material.shininess",         // MaterialSpecularPower

    "u_Texture",                    // Texture
    "u_Texture1",                   // Texture1
    "u_Texture2",                   // Texture2
    "u_Texture3",                   // Texture3
    "u_Texture4",                   // Texture4
    "u_Texture5",                   // Texture5
    "u_Texture6",                   // Texture6
    "u_Texture7",                   // Texture7

    "u_CubeMapTexture",             // CubeMapTexture
    "u_CubeMapTexture1",            // CubeMapTexture1
    "u_CubeMapTexture2",            // CubeMapTexture2
    "u_CubeMapTexture3",            // CubeMapTexture3
    "u_CubeMapTexture4",            // CubeMapTexture4
    "u_CubeMapTexture5",            // CubeMapTexture5
    "u_CubeMapTexture6",            // CubeMapTexture6
    "u_CubeMapTexture7",            // CubeMapTexture7

    "u_Light[0].type",              // LightType
    "u_Light[1].type",              // LightType1
    "u_Light[2].type",              // LightType2
    "u_Light[3].type",              // LightType3
    "u_Light[4].type",              // LightType4
    "u_Light[5].type",              // LightType5
    "u_Light[6].type",              // LightType6
    "u_Light[7].type",              // LightType7

    "u_Light[0].ambient",           // LightAmbient
    "u_Light[1].ambient",           // LightAmbient1
    "u_Light[2].ambient",           // LightAmbient2
    "u_Light[3].ambient",           // LightAmbient3
    "u_Light[4].ambient",           // LightAmbient4
    "u_Light[5].ambient",           // LightAmbient5
    "u_Light[6].ambient",           // LightAmbient6
    "u_Light[7].ambient",           // LightAmbient7

    "u_Light[0].diffuse",           // LightDiffuse
    "u_Light[1].diffuse",           // LightDiffuse1
    "u_Light[2].diffuse",           // LightDiffuse2
    "u_Light[3].diffuse",           // LightDiffuse3
    "u_Light[4].diffuse",           // LightDiffuse4
    "u_Light[5].diffuse",           // LightDiffuse5
    "u_Light[6].diffuse",           // LightDiffuse6
    "u_Light[7].diffuse",           // LightDiffuse7

    "u_Light[0].specular",          // LightSpecular
    "u_Light[1].specular",          // LightSpecular1
    "u_Light[2].specular",          // LightSpecular2
    "u_Light[3].specular",          // LightSpecular3
    "u_Light[4].specular",          // LightSpecular4
    "u_Light[5].specular",          // LightSpecular5
    "u_Light[6].specular",          // LightSpecular6
    "u_Light[7].specular",          // LightSpecular7

    "u_Light[0].position",          // LightPosition
    "u_Light[1].position",          // LightPosition1
    "u_Light[2].position",          // LightPosition2
    "u_Light[3].position",          // LightPosition3
    "u_Light[4].position",          // LightPosition4
    "u_Light[5].position",          // LightPosition5
    "u_Light[6].position",          // LightPosition6
    "u_Light[7].position",          // LightPosition7

    "u_Light[0].direction",         // LightDirection
    "u_Light[1].direction",         // LightDirection1
    "u_Light[2].direction",         // LightDirection2
    "u_Light[3].direction",         // LightDirection3
    "u_Light[4].direction",         // LightDirection4
    "u_Light[5].direction",         // LightDirection5
    "u_Light[6].direction",         // LightDirection6
    "u_Light[7].direction",         // LightDirection7

    "u_Light[0].halfplane",         // LightHalfplane
    "u_Light[1].halfplane",         // LightHalfplane1
    "u_Light[2].halfplane",         // LightHalfplane2
    "u_Light[3].halfplane",         // LightHalfplane3
    "u_Light[4].halfplane",         // LightHalfplane4
    "u_Light[5].halfplane",         // LightHalfplane5
    "u_Light[6].halfplane",         // LightHalfplane6
    "u_Light[7].halfplane",         // LightHalfplane7

    "u_Light[0].attenuation",       // LightAttenuation
    "u_Light[1].attenuation",       // LightAttenuation1
    "u_Light[2].attenuation",       // LightAttenuation2
    "u_Light[3].attenuation",       // LightAttenuation3
    "u_Light[4].attenuation",       // LightAttenuation4
    "u_Light[5].attenuation",       // LightAttenuation5
    "u_Light[6].attenuation",       // LightAttenuation6
    "u_Light[7].attenuation",       // LightAttenuation7

    "u_Light[0].spotCosCutoff",     // LightSpotCosCutoff
    "u_Light[1].spotCosCutoff",     // LightSpotCosCutoff1
    "u_Light[2].spotCosCutoff",     // LightSpotCosCutoff2
    "u_Light[3].spotCosCutoff",     // LightSpotCosCutoff3
    "u_Light[4].spotCosCutoff",     // LightSpotCosCutoff4
    "u_Light[5].spotCosCutoff",     // LightSpotCosCutoff5
    "u_Light[6].spotCosCutoff",     // LightSpotCosCutoff6
    "u_Light[7].spotCosCutoff",     // LightSpotCosCutoff7

    "u_Light[0].spotExponent",      // LightSpotExponent
    "u_Light[1].spotExponent",      // LightSpotExponent1
    "u_Light[2].spotExponent",      // LightSpotExponent2
    "u_Light[3].spotExponent",      // LightSpotExponent3
    "u_Light[4].spotExponent",      // LightSpotExponent4
    "u_Light[5].spotExponent",      // LightSpotExponent5
    "u_Light[6].spotExponent",      // LightSpotExponent6
    "u_Light[7].spotExponent",      // LightSpotExponent7

    "u_Light[0].range",             // LightRange
    "u_Light[1].range",             // LightRange1
    "u_Light[2].range",             // LightRange2
    "u_Light[3].range",             // LightRange3
    "u_Light[4].range",             // LightRange4
    "u_Light[5].range",             // LightRange5
    "u_Light[6].range",             // LightRange6
    "u_Light[7].range",             // LightRange7

    "u_Light[0].enabled",           // LightEnabled
    "u_Light[1].enabled",           // LightEnabled1
    "u_Light[2].enabled",           // LightEnabled2
    "u_Light[3].enabled",           // LightEnabled3
    "u_Light[4].enabled",           // LightEnabled4
    "u_Light[5].enabled",           // LightEnabled5
    "u_Light[6].enabled",           // LightEnabled6
    "u_Light[7].enabled",           // LightEnabled7

    "u_Light[0].cameraLookAtVector",// LightCameraLookAtVector
    "u_Light[1].cameraLookAtVector",// LightCameraLookAtVector1
    "u_Light[2].cameraLookAtVector",// LightCameraLookAtVector2
    "u_Light[3].cameraLookAtVector",// LightCameraLookAtVector3
    "u_Light[4].cameraLookAtVector",// LightCameraLookAtVector4
    "u_Light[5].cameraLookAtVector",// LightCameraLookAtVector5
    "u_Light[6].cameraLookAtVector",// LightCameraLookAtVector6
    "u_Light[7].cameraLookAtVector",// LightCameraLookAtVector7

    "u_MorphWeight",                // MorphWeightArray

    "u_CanvasPivot",                // CanvasPivot
    "u_CanvasSize",                 // CanvasSize

    "ub_Material",                  // MaterialBlock
    "ub_Lights",                    // LightBlock
};

const bool ShaderParamNames::m_isUniformBlock[] = {
    false, // ModelMatrix3
    false, // ModelViewMatrix3
    false, // NormalModelMatrix3
    false, // NormalModelViewMatrix3
    false, // ModelMatrix4
    false, // ModelViewMatrix4
    false, // ProjectionMatrix4
    false, // ModelViewProjectionMatrix4
    false, // CameraLookAtVector
    false, // CameraPosition
    false, // PointSpriteSize

    false, // MaterialAmbient
    false, // MaterialDiffuse
    false, // MaterialEmissive
    false, // MaterialSpecular
    false, // MaterialSpecularPower

    false, // Texture
    false, // Texture1
    false, // Texture2
    false, // Texture3
    false, // Texture4
    false, // Texture5
    false, // Texture6
    false, // Texture7

    false, // CubeMapTexture
    false, // CubeMapTexture1
    false, // CubeMapTexture2
    false, // CubeMapTexture3
    false, // CubeMapTexture4
    false, // CubeMapTexture5
    false, // CubeMapTexture6
    false, // CubeMapTexture7

    false, // LightType
    false, // LightType1
    false, // LightType2
    false, // LightType3
    false, // LightType4
    false, // LightType5
    false, // LightType6
    false, // LightType7

    false, // LightAmbient
    false, // LightAmbient1
    false, // LightAmbient2
    false, // LightAmbient3
    false, // LightAmbient4
    false, // LightAmbient5
    false, // LightAmbient6
    false, // LightAmbient7

    false, // LightDiffuse
    false, // LightDiffuse1
    false, // LightDiffuse2
    false, // LightDiffuse3
    false, // LightDiffuse4
    false, // LightDiffuse5
    false, // LightDiffuse6
    false, // LightDiffuse7

    false, // LightSpecular
    false, // LightSpecular1
    false, // LightSpecular2
    false, // LightSpecular3
    false, // LightSpecular4
    false, // LightSpecular5
    false, // LightSpecular6
    false, // LightSpecular7

    false, // LightPosition
    false, // LightPosition1
    false, // LightPosition2
    false, // LightPosition3
    false, // LightPosition4
    false, // LightPosition5
    false, // LightPosition6
    false, // LightPosition7

    false, // LightDirection
    false, // LightDirection1
    false, // LightDirection2
    false, // LightDirection3
    false, // LightDirection4
    false, // LightDirection5
    false, // LightDirection6
    false, // LightDirection7

    false, // LightHalfplane
    false, // LightHalfplane1
    false, // LightHalfplane2
    false, // LightHalfplane3
    false, // LightHalfplane4
    false, // LightHalfplane5
    false, // LightHalfplane6
    false, // LightHalfplane7

    false, // LightAttenuation
    false, // LightAttenuation1
    false, // LightAttenuation2
    false, // LightAttenuation3
    false, // LightAttenuation4
    false, // LightAttenuation5
    false, // LightAttenuation6
    false, // LightAttenuation7

    false, // LightSpotCosCutoff
    false, // LightSpotCosCutoff1
    false, // LightSpotCosCutoff2
    false, // LightSpotCosCutoff3
    false, // LightSpotCosCutoff4
    false, // LightSpotCosCutoff5
    false, // LightSpotCosCutoff6
    false, // LightSpotCosCutoff7

    false, // LightSpotExponent
    false, // LightSpotExponent1
    false, // LightSpotExponent2
    false, // LightSpotExponent3
    false, // LightSpotExponent4
    false, // LightSpotExponent5
    false, // LightSpotExponent6
    false, // LightSpotExponent7

    false, // LightRange
    false, // LightRange1
    false, // LightRange2
    false, // LightRange3
    false, // LightRange4
    false, // LightRange5
    false, // LightRange6
    false, // LightRange7

    false, // LightEnabled
    false, // LightEnabled1
    false, // LightEnabled2
    false, // LightEnabled3
    false, // LightEnabled4
    false, // LightEnabled5
    false, // LightEnabled6
    false, // LightEnabled7

    false, // LightCameraLookAtVector
    false, // LightCameraLookAtVector1
    false, // LightCameraLookAtVector2
    false, // LightCameraLookAtVector3
    false, // LightCameraLookAtVector4
    false, // LightCameraLookAtVector5
    false, // LightCameraLookAtVector6
    false, // LightCameraLookAtVector7

    false, // MorphWeightArray

    false, // CanvasPivot,
    false, // CanvasSize,

    true,  // MaterialBlock
    true   // LightsBlock
};

void ShaderParamNames::SetUniformName(UniformSemantic semantic, const Char* name)
{
    m_uniformNames[semantic] = name;
    m_uniformNamesHashes[semantic] = FeatStd::Hash::CalcHash(name);
}

void ShaderParamNames::InitUniformNamesHashes()
{
    if (!m_areUniformNamesHashesInitialized) {
        for (UInt i = 0; i < ShaderParamNames::UniformSemanticCount; ++i) {
            m_uniformNamesHashes[i] = FeatStd::Hash::CalcHash(ShaderParamNames::m_uniformNames[i]);
        }

        m_areUniformNamesHashesInitialized = true;
    }
}

UInt32 ShaderParamNames::m_uniformNamesHashes[(sizeof(m_uniformNames) / sizeof(m_uniformNames[0]))] = {};

bool ShaderParamNames::m_areUniformNamesHashesInitialized = false;

/**************
 * Attributes *
 **************/


const Char* ShaderParamNames::m_attributeNames[] =
{
    "a_Position",
    "a_Position1",
    "a_Position2",
    "a_Position3",
    "a_Position4",
    "a_Position5",
    "a_Position6",
    "a_Position7",

    "a_PositionTransformed",
    "a_PositionTransformed1",
    "a_PositionTransformed2",
    "a_PositionTransformed3",
    "a_PositionTransformed4",
    "a_PositionTransformed5",
    "a_PositionTransformed6",
    "a_PositionTransformed7",

    "a_Normal",
    "a_Normal1",
    "a_Normal2",
    "a_Normal3",
    "a_Normal4",
    "a_Normal5",
    "a_Normal6",
    "a_Normal7",

    "a_TextureCoordinate",
    "a_TextureCoordinate1",
    "a_TextureCoordinate2",
    "a_TextureCoordinate3",
    "a_TextureCoordinate4",
    "a_TextureCoordinate5",
    "a_TextureCoordinate6",
    "a_TextureCoordinate7",

    "a_Color",
    "a_Color1",
    "a_Color2",
    "a_Color3",
    "a_Color4",
    "a_Color5",
    "a_Color6",
    "a_Color7",

    "a_BlendWeight",
    "a_BlendWeight1",
    "a_BlendWeight2",
    "a_BlendWeight3",
    "a_BlendWeight4",
    "a_BlendWeight5",
    "a_BlendWeight6",
    "a_BlendWeight7",

    "a_BlendIndex",
    "a_BlendIndex1",
    "a_BlendIndex2",
    "a_BlendIndex3",
    "a_BlendIndex4",
    "a_BlendIndex5",
    "a_BlendIndex6",
    "a_BlendIndex7",

    "a_PointSize",
    "a_PointSize1",
    "a_PointSize2",
    "a_PointSize3",
    "a_PointSize4",
    "a_PointSize5",
    "a_PointSize6",
    "a_PointSize7",

    "a_Tangent",
    "a_Tangent1",
    "a_Tangent2",
    "a_Tangent3",
    "a_Tangent4",
    "a_Tangent5",
    "a_Tangent6",
    "a_Tangent7",

    "a_BiNormal",
    "a_BiNormal1",
    "a_BiNormal2",
    "a_BiNormal3",
    "a_BiNormal4",
    "a_BiNormal5",
    "a_BiNormal6",
    "a_BiNormal7",

    "a_TesselationFactor",
    "a_TesselationFactor1",
    "a_TesselationFactor2",
    "a_TesselationFactor3",
    "a_TesselationFactor4",
    "a_TesselationFactor5",
    "a_TesselationFactor6",
    "a_TesselationFactor7",

    "a_Fog",
    "a_Fog1",
    "a_Fog2",
    "a_Fog3",
    "a_Fog4",
    "a_Fog5",
    "a_Fog6",
    "a_Fog7",

    "a_Depth",
    "a_Depth1",
    "a_Depth2",
    "a_Depth3",
    "a_Depth4",
    "a_Depth5",
    "a_Depth6",
    "a_Depth7",

    "a_Sample",
    "a_Sample1",
    "a_Sample2",
    "a_Sample3",
    "a_Sample4",
    "a_Sample5",
    "a_Sample6",
    "a_Sample7",

    "a_Custom",
    "a_Custom1",
    "a_Custom2",
    "a_Custom3",
    "a_Custom4",
    "a_Custom5",
    "a_Custom6",
    "a_Custom7"

};

ShaderParamNames::AttributeSemantic ShaderParamNames::GetAttributeSemantic(VertexGeometry::VertexUsage usage, UInt8 usageIndex)
{
    return static_cast<ShaderParamNames::AttributeSemantic>(
        ((static_cast<UInt>(usage) - static_cast<UInt>(VertexGeometry::Position)) << 0x3) + usageIndex);
}

void ShaderParamNames::SetAttributeName(AttributeSemantic semantic, const Char* name)
{
    m_attributeNames[semantic] = name;
    m_attributeNamesHashes[semantic] = FeatStd::Hash::CalcHash(name);
}

void ShaderParamNames::InitAttributeNamesHashes()
{
    if (!m_areAttributeNamesHashesInitialized) {
        for (UInt i = 0; i < ShaderParamNames::AttributeSemanticCount; ++i) {
            m_attributeNamesHashes[i] = FeatStd::Hash::CalcHash(ShaderParamNames::m_attributeNames[i]);
        }

        m_areAttributeNamesHashesInitialized = true;
    }
}

UInt32 ShaderParamNames::m_attributeNamesHashes[(sizeof(m_attributeNames) / sizeof(m_attributeNames[0]))] = {};

bool ShaderParamNames::m_areAttributeNamesHashesInitialized = false;

void ShaderParamNames::CheckSizes()
{
    FEATSTD_COMPILETIME_ASSERT(sizeof(m_uniformNames) == sizeof(m_uniformNames[0]) * static_cast<UInt32>(UniformSemanticCount));
    FEATSTD_COMPILETIME_ASSERT(sizeof(m_isUniformBlock) == sizeof(m_isUniformBlock[0]) * static_cast<UInt32>(UniformSemanticCount));
    FEATSTD_COMPILETIME_ASSERT(sizeof(m_attributeNames) == sizeof(m_attributeNames[0]) * static_cast<UInt32>(AttributeSemanticCount));
}

} // namespace Candera

