//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "RenderBuffer.h"
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>
#include <Candera/Engine3D/Core/Renderer.h>

namespace Candera {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

    RenderBuffer::RenderBuffer() :
        Base(),
        m_format(InvalidFormat),
        m_width(0),
        m_height(0),
        m_videoMemoryHandle(InvalidHandle)
    {
    }

    RenderBuffer::~RenderBuffer()
    {
        static_cast<void>(Unload(Force));
    }

    MemoryManagement::SharedPointer<RenderBuffer> RenderBuffer::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        RenderBuffer* ptr = FEATSTD_NEW(RenderBuffer)();
        if (ptr == 0) {
            FEATSTD_LOG_ERROR("Render buffer create failed, out of memory.");
        }
        MemoryManagement::SharedPointer<RenderBuffer> sharedPointer(ptr);
        return sharedPointer;
    }

    bool RenderBuffer::SetWidth(Int32 width)
    {
        bool result = false;
        if (! IsUploaded()) {
            m_width = width;
            result = true;
        }
        return result;
    }

    bool RenderBuffer::SetHeight(Int32 height)
    {
        bool result = false;
        if (! IsUploaded()) {
            m_height = height;
            result = true;
        }
        return result;
    }

    bool RenderBuffer::SetFormat(Format format)
    {
        bool result = false;
        if (! IsUploaded()) {
            m_format = format;
            result = true;
        }
        return result;
    }

    bool RenderBuffer::Activate() const
    {
        return RenderDevice::ActivateRenderBuffer(*this);
    }

    bool RenderBuffer::UploadInternal(LoadingHint loadingHint)
    {
        return (Renderer::UploadRenderBuffer(*this, loadingHint));
    }

    bool RenderBuffer::UnloadInternal(LoadingHint loadingHint)
    {
        return (Renderer::UnloadRenderBuffer(*this, loadingHint));
    }
} // end namespace
