//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ReflectionCamera.h"
#include <Candera/Engine3D/Mathematics/Math3D.h>

namespace Candera {
ReflectionCamera::ReflectionCamera() :
    Base(),
    m_sourceCamera(0),
    m_plane()
{
}

ReflectionCamera::ReflectionCamera(const ReflectionCamera &reflectionCamera) :
    Base(reflectionCamera),
    m_sourceCamera(0),
    m_plane(reflectionCamera.m_plane)
{
}

ReflectionCamera::~ReflectionCamera()
{
    m_sourceCamera = 0;
}

ReflectionCamera* ReflectionCamera::Create()
{
    return FEATSTD_NEW(ReflectionCamera);
}

void ReflectionCamera::DisposeSelf()
{
    FEATSTD_DELETE(this);
}

void ReflectionCamera::SetReflectionPlane(const Plane& plane)
{
    m_plane = plane;
    m_plane.Normalize();
}

FEATSTD_RTTI_DEFINITION(ReflectionCamera, Camera)

ReflectionCamera* ReflectionCamera::Clone() const
{
    ReflectionCamera* reflectionCamera = FEATSTD_NEW(ReflectionCamera)(*this);
    return reflectionCamera;
}

bool ReflectionCamera::Activate()
{
    bool isSuccess = (m_sourceCamera != 0);
    if (isSuccess) {
        SyncViewProjectionFromSourceCamera();
        ReflectView();
        isSuccess = Base::Activate();
    }

    return isSuccess;
}

void ReflectionCamera::SyncViewProjectionFromSourceCamera()
{
    if (m_sourceCamera != 0) {
        SetViewMatrix(m_sourceCamera->GetViewMatrix());
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1555, Candera::ReflectionCamera::m_projection, CANDERA_LINT_REASON_ASSOCIATION)
        SetProjection(m_sourceCamera->GetProjection());
    }
}

void ReflectionCamera::ReflectView()
{
    //Create matrix out of reflection plane.
    Matrix4 reflectMatrix;
    static_cast<void>(Math3D::SetReflection(reflectMatrix, m_plane));
    //Reflect current view matrix by composite reflection matrix
    reflectMatrix *= GetViewMatrix();
    //Set reflected view matrix
    SetViewMatrix(reflectMatrix);
}
} // namespace Candera
