//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_ProjectionListener_h
#define Candera_ProjectionListener_h

namespace Candera {

/** @addtogroup Core3D
 *  @{
 */

class Projection;

/**
* @brief    A ProjectionListener defines hooks that are called when a projection's parameters are changed.
*           In order to register a ProjectionListener to a Projection simply derive from ProjectionListener and override pure virtual functions with custom code.
*/
class ProjectionListener
{
    public:
        /**
          * Constructs a ProjectionListener object.
          */
        ProjectionListener() {}

        /**
          * Destructs a ProjectionListener object.
          */
        virtual ~ProjectionListener() {}

        /**
          * Is invoked when a parameter of the projection has been modified.
          * At the time when this function is called, the projection matrix may not have been updated.
          * @param projection The projection to listen to.
          */
        virtual void OnProjectionChanged(Projection* projection) = 0;

    protected:
        ProjectionListener(const ProjectionListener&) {}
        ProjectionListener& operator=(const ProjectionListener&) { return *this; }

};

/** @} */ // end of Core3D

} // namespace Candera


#endif
