//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "Projection.h"
#include <Candera/Engine3D/Core/ProjectionListener.h>

namespace Candera {

    FEATSTD_RTTI_BASECLASS_DEFINITION(Projection)

Projection::Projection():
    m_projection()
{    
}

Projection::~Projection()
{
}

Projection::Projection(const Candera::Projection &other):
    m_projection(other.m_projection)
{
}

void Projection::NotifyListenersOnProjectionChanged()
{
    for (ProjectionListenerContainer::Iterator it = m_projectionListeners.Begin(); it != m_projectionListeners.End(); ++it) {
        (static_cast<ProjectionListener*>(*it))->OnProjectionChanged(this);
    }
}

void Projection::SetProjectionMatrix(const Candera::Matrix4 &projectionMatrix) const
{    
    m_projection = projectionMatrix;
}

const Matrix4& Projection::GetProjectionMatrix() const
{
    UpdateProjectionMatrix();
    return m_projection;
}

bool Projection::AddProjectionListener(ProjectionListener* listener){
    bool isSuccessful = false;
    if (listener != 0) {
        isSuccessful = m_projectionListeners.Append(listener);
    }
    return isSuccessful;
}

bool Projection::RemoveProjectionListener(ProjectionListener* listener){
    bool isSuccessful = false;
    if (listener != 0) {
        isSuccessful = m_projectionListeners.Remove(listener);
    }
    return isSuccessful;
}



} // namespace Candera
