//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "PixelBuffer.h"

#include <Candera/Engine3D/Core/Renderer.h>

namespace Candera {

PixelBuffer::PixelBuffer(SizeType size, bool isPixelPack)
    :
    m_size(size),
    m_isPixelPack(isPixelPack)
{
    MemoryPlatform::Set(m_deviceHandle, 0, sizeof(m_deviceHandle));
}

PixelBuffer::~PixelBuffer()
{
    static_cast<void>(Unload(ForceAll));
}

PixelBuffer::PixelBuffer(const PixelBuffer& rhs)
    :
    Base(),
    m_size(rhs.m_size),
    m_isPixelPack(rhs.m_isPixelPack)
{
    MemoryPlatform::Copy(m_deviceHandle, rhs.m_deviceHandle, sizeof(m_deviceHandle));
}

bool PixelBuffer::UploadInternal(LoadingHint loadingHint)
{
    return Renderer::UploadPixelBuffer(*this, loadingHint);
}

bool PixelBuffer::UnloadInternal(LoadingHint loadingHint)
{
    return Renderer::UnloadPixelBuffer(*this, loadingHint);
}

}
