//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_PICKFRUSTUM_H)
#define CANDERA_PICKFRUSTUM_H

#include <Candera/Engine3D/Core/Frustum.h>
#include <Candera/System/Mathematics/Rectangle.h>

namespace Candera {

/**  @addtogroup Core3D
 *   @{
 */
 
class Camera;

/**
*  @brief A PickFrustum can be used to determine whether objects in world space
*         are inside a rectangular area (selection rectangle) on screen space or not.
*         From the screen space region a Frustum, that goes from the cameras near to the
*         the cameras far plane, is created.
*/

class PickFrustum : public Frustum {

    friend class PickFrustumCameraListener;

    public:        

        /**
         *  Constructor
         */
        PickFrustum(Camera* camera, const Rectangle& rect);

        /**
         *  Destructor
         */
        ~PickFrustum(); //non-virtual

        /**   
         *  Sets the camera for the PickFrustum.
         *  @param camera Camera to be set for the PickFrustum
         */
        void SetCamera(Camera* camera);

        /**   
         *  Gets the camera from the PickFrustum.
         *  @return Camera of this PickFrustum
         */
        const Camera* GetCamera() const { return m_camera; } 

        /**
         * Sets the selection rectangle to determine the frustum from.
         * The rectangles values have to be in screen space (pixels).
         * Recalculate() is called after setting the new rectangle.
         * @param rect The rectangle to set.
         */
        void SetRectangle(const Rectangle& rect);

        /**
         * Return the selection rectangle used to determine the frustum from.
         * Values are in screen space (pixels).
         * @return The rectangle used to determine the frustum from.
         */
        const Rectangle& GetRectangle() const { return m_rectangle; }

        /**   
         *  Calculates the frustum planes.
         *  Has to be called each time the view or projection of the camera or the selection rectangle changes.
         */
        virtual void Recalculate() override;

    private:
        Camera* m_camera;
        Rectangle m_rectangle;
};
 
/**  @} */ // end of Core3D
 
} //namespace Candera

#endif // CANDERA_VIEWINGFRUSTUM_H
