//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "MultiPassAppearance.h"
#include <Candera/Engine3D/Core/Shader.h>
#include <Candera/Engine3D/Core/Texture.h>
#include <Candera/Engine3D/Core/Material.h>
#include <Candera/Engine3D/Core/Renderer.h>
#include <Candera/System/Container/Vector.h>
#include <Candera/System/Diagnostics/Log.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>

namespace Candera {
    using namespace Diagnostics;
    using namespace MemoryManagement;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

MultiPassAppearance::MultiPassAppearance():
Base(),
m_next(0)
{
}

MultiPassAppearance::MultiPassAppearance(const MultiPassAppearance& appearance):
Base(appearance),
m_next(0)
{
}

MultiPassAppearance::SharedPointer MultiPassAppearance::Create()
{
    CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

    MultiPassAppearance* ptr = FEATSTD_NEW(MultiPassAppearance);
    if (ptr == 0) {
        FEATSTD_LOG_ERROR("Appearance create failed, out of memory.");
    }

    MultiPassAppearance::SharedPointer sharedPointer(ptr);

    return sharedPointer;
}

Appearance::SharedPointer MultiPassAppearance::Clone() const
{
    return Appearance::SharedPointer(FEATSTD_NEW(MultiPassAppearance)(*this));
}

bool MultiPassAppearance::Upload()
{
    bool finalResult = Base::Upload();

    if (m_next != 0) {
        finalResult = finalResult && m_next->Upload();
    }

    return finalResult;
}

bool MultiPassAppearance::Unload()
{
    bool finalResult = Base::Unload();

    if (m_next != 0) {
        finalResult = finalResult && m_next->Unload();
    }

    return finalResult;
}

FEATSTD_RTTI_DEFINITION(MultiPassAppearance, Appearance)

} // namespace Candera
