//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_GLYPHATLASTEXTNODERENDERER_H
#define CANDERA_GLYPHATLASTEXTNODERENDERER_H

#ifdef CANDERA_2D_OVER_3D_ENABLED

#include <Candera/Engine2D/Core/TextNodeRenderer/TextNodeRenderer.h>
#include <Candera/Engine3D/Core/GlyphAtlasTextRenderContext.h>
#include <Candera/EngineBase/Common/GlyphAtlasCommonUtils.h>

namespace Candera {

class GlyphAtlasTextRenderContext;

class GlyphAtlasTextNodeRenderer : public TextNodeRenderer
{

public:
    /**
     *  Creates a new instance.
     *  @return  A new instance.
     */
    static GlyphAtlasTextNodeRenderer* Create();

    // overrides TextNodeRenderer::Clone
    virtual GlyphAtlasTextNodeRenderer* Clone() const override;

    // overrides TextNodeRenderer::Dispose
    virtual void Dispose() override;

    // overrides TextNodeRenderer::GetMeasureReferenceContext
    virtual const TextRendering::TextRenderContext* GetMeasureReferenceContext() const override;

    // overrides TextNodeRenderer::PreRender
    virtual bool PreRenderInternal(const TextNode2D& textNode);

    // overrides TextNodeRenderer::Render
    virtual void RenderInternal(TextNode2D& textNode, RenderTarget2D* renderTarget, const Matrix3x2& localTransform);

private:
    FEATSTD_MAKE_CLASS_STATIC(GlyphAtlasTextNodeRenderer);
    FEATSTD_MAKE_CLASS_UNCOPYABLE(GlyphAtlasTextNodeRenderer);

    // overrides TextNodeRenderer::UploadSelf
    virtual bool UploadSelf() override;

    // overrides TextNodeRenderer::UnloadSelf
    virtual bool UnloadSelf() override;

    GlyphAtlasTextRenderContext m_textRenderContext;
    bool m_hasChanged;

    //
    Internal::GlyphAtlasBitmapUsageTracker<BitmapImage2D> m_bitmapTracker;
};

} // namespace Candera

#endif

#endif
