//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_GlyphAtlasTextContainer_h
#define Candera_GlyphAtlasTextContainer_h

#include <Candera/Environment.h>
#include <Candera/Engine3D/Canvas/CanvasText.h>
#include <Candera/Engine3D/Core/GlyphAtlas3D.h>

namespace Candera {
    namespace Internal {
        class GlyphAtlas3DTextRenderContext;
        class GlyphAtlasTextContainer {
        public:
            typedef CanvasText TextNode;
            struct GlyphInfo {
                SizeType BitmapImageIndex;
                GlyphAtlas3D::Entry::Rect UvRect;
                Int16 X;
                Int16 Y;
                Int16 Width;
                Int16 Height;
            };
            typedef Candera::Internal::Vector<GlyphInfo> GlyphInfoVector;

            TextNode * GetTextNode() const; 

            void SetTextNode(TextNode * textNode);

            void UpdateContainer(TextNode * textNode);
            
            GlyphInfo const * operator[](SizeType index) const;

            SizeType Size() const
            {
                return m_glyphInfos.Size();
            }

            bool IsContainerChangeConsumed() const {
                return m_containerChangeConsumed;
            }
            
            void SetContainerChangeConsumed(bool isContainerChangeConsumed)
            {
                m_containerChangeConsumed = isContainerChangeConsumed;
            }

            GlyphAtlasTextContainer();
        private:
            friend class GlyphAtlas3DTextRenderContext;
            GlyphInfoVector m_glyphInfos;
            TextNode * m_textNode;
            Candera::Color m_currentTextColor;

            bool m_containerChangeConsumed;
                       
            void Clear();
        };
    }
}

#endif // Candera_GlyphAtlasTextContainer_h

