//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlyphAtlas3D.h"

#include <CanderaPlatform/Device/Common/Base/ContextResourcePool.h>

namespace Candera {

class GlyphAtlas3DArray
{
public:
    GlyphAtlas3DArray()
    {
        for (SizeType i = 0; i < CANDERA_MAX_CONTEXT_COUNT; ++i) {
            m_glyphAtlases[i] = CANDERA_NEW(GlyphAtlas3D);
        }
    }

    ~GlyphAtlas3DArray()
    {
        for (SizeType i = 0; i < CANDERA_MAX_CONTEXT_COUNT; ++i) {
            CANDERA_DELETE(m_glyphAtlases[i]);
            m_glyphAtlases[i] = 0;
        }
    }

    GlyphAtlas3D& operator[](SizeType index) const
    {
        FEATSTD_DEBUG_ASSERT(index < CANDERA_MAX_CONTEXT_COUNT);
        return *(m_glyphAtlases[index]);
    }

private:
    GlyphAtlas3D* m_glyphAtlases[CANDERA_MAX_CONTEXT_COUNT];
};

template<>
GlyphAtlas3D& GlyphAtlas3D::GetInstance()
{
    FEATSTD_SYNCED_STATIC_OBJECT(GlyphAtlas3DArray, s_instance);
    return s_instance[ContextResourcePool::GetActive().GetIndex()];
}

}
