//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GenericProjection_H)
#define GenericProjection_H

#include <Candera/Engine3D/Core/Projection.h>

namespace Candera {
/**
 *  @addtogroup Core3D
 *  @{
 */

class Projection;
class Matrix4;

/**
 *  @brief   Projection using an externally supplied matrix.
 */
class GenericProjection : public Projection
{
    FEATSTD_TYPEDEF_BASE(Projection);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(GenericProjection);
        /**
         *  Creates an instance of this class.
         *  @return   A MemoryManagement::SharedPointer which manages the lifetime of the instance.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         *  Destructor
         */
        virtual ~GenericProjection() override;

        // Overrides Projection::Clone.
        virtual Projection::SharedPointer Clone() const override;

        FEATSTD_RTTI_DECLARATION();

        /**
         *  Assigns the Matrix.
         *  @param matrix The Matrix that is assigned.
         */
        void SetMatrix(const Matrix4& matrix);

        /**
         *  Retrieves the matrix.
         *  @return The Matrix.
         */
        const Matrix4& GetMatrix() const;

    protected:
        // override (Projection)
        virtual void UpdateProjectionMatrix() const override;

    private:
        // private because only ::Create() should be used to create an instance of this class
        CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::GenericProjection::GenericProjection, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
        GenericProjection();
        GenericProjection(const GenericProjection& other);
        GenericProjection& operator=(const GenericProjection& other);
};

/** @} */ // end of Core3D
} // namespace Candera

#endif

