//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericProjection.h"
#include <Candera/System/Diagnostics/Log.h>
#include <Candera/System/MemoryManagement/CanderaHeap.h>

namespace Candera {
    using namespace Diagnostics;

    FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

GenericProjection::GenericProjection():
Projection()
{
}

GenericProjection::SharedPointer GenericProjection::Create()
{
    CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

    GenericProjection* ptr = FEATSTD_NEW(GenericProjection)();
    if (ptr == 0) {
        FEATSTD_LOG_ERROR("Generic projection create failed, out of memory.");
    }
    GenericProjection::SharedPointer sharedPointer(ptr);
    return sharedPointer;
}

GenericProjection::~GenericProjection()
{
}

Projection::SharedPointer GenericProjection::Clone() const
{
    return SharedPointer(FEATSTD_NEW(GenericProjection)(*this));
}

GenericProjection::GenericProjection(const GenericProjection& other):
    Projection(other)
{
}

FEATSTD_RTTI_DEFINITION(GenericProjection, Projection)

CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1762, Candera::GenericProjection::SetMatrix, SetMatrix is semantically non-const)
void GenericProjection::SetMatrix(const Matrix4& matrix)
{
    SetProjectionMatrix(matrix);
    NotifyListenersOnProjectionChanged();
}

const Matrix4& GenericProjection::GetMatrix() const
{
    return GetProjectionMatrix();
}

void GenericProjection::UpdateProjectionMatrix() const
{
}
}

