//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef Candera_DistanceToCameraLodCriterion_h
#define Candera_DistanceToCameraLodCriterion_h

#include <Candera/Engine3D/Core/LodCriterion.h>

namespace Candera {

/** @addtogroup Core3D
 *  @{
 */
 
//Forward declaration
class LodNode;

/**
 *  @brief The class DistanceToCameraLodCriterion returns the distance to camera.
 */
class DistanceToCameraLodCriterion: public LodCriterion
{
    FEATSTD_TYPEDEF_BASE(LodCriterion);

    public:

        FEATSTD_RTTI_DECLARATION();

        /**
         *  Constructor
         */
        DistanceToCameraLodCriterion() {}

        /**
         *  Destructor
         */
        virtual ~DistanceToCameraLodCriterion() override {}

        /**
         *  Retrieves a criterion value for further LOD level calculation.
         *  @param lodNode LodNode for which criterion needs to be evaluated.
         *  @return Distance to camera if camera exists. -1.0F otherwise.
         */
        virtual Float GetCriterionValue(const LodNode& lodNode) const override;
};
 
/** @} */ // end of Core3D
 
}

#endif // Candera_DistanceToCameraLodCriterion_h
