//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_CAMERALOOKATNODECONTROLLER_H
#define CANDERA_CAMERALOOKATNODECONTROLLER_H

#include <Candera/Engine3D/Core/Node.h>
#include <Candera/System/ControllerSystem/ControllerComponent.h>

namespace Candera {

class CameraLookAtNodeController : public ControllerComponent
{
public:
    FEATSTD_TYPEDEF_BASE(ControllerComponent);
    FEATSTD_RTTI_DECLARATION();

    virtual ~CameraLookAtNodeController() override {};

protected:
    virtual void LateUpdate(ControllerEntity* entity) override;

private:
    CameraLookAtNodeController() {}

    friend class EntityComponentSystem::ComponentSystem<ControllerComponent, ControllerEntity>;
    friend class ControllerSystem;
};

}

#endif
