//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <Candera/Engine3D/Core/BreakNodeCameraRenderStrategy.h>
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera {
    using namespace Diagnostics;

FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

FEATSTD_RTTI_DEFINITION(BreakNodeCameraRenderStrategy, CameraRenderStrategy)

BreakNodeCameraRenderStrategy::BreakNodeCameraRenderStrategy() :
    Base(/* isDrawcallBatchingPathUsed */ true),
    m_isRenderPassResuming(false),
    m_actionOnBreakNode(CameraRenderStrategy::PauseRenderPass)
{
}

CameraRenderStrategy::RenderPassAction BreakNodeCameraRenderStrategy::GetRenderPassAction(const Node* nextNode)
{
    RenderPassAction renderPassAction = ProceedRenderPass;

    if (m_isRenderPassResuming) {
        m_isRenderPassResuming = false;
    }
    else if (m_breakNodeList.Contains(const_cast<Node*>(nextNode))){
        renderPassAction = m_actionOnBreakNode;
    }
    else {
        //do nothing
    }
    return renderPassAction;
}

void BreakNodeCameraRenderStrategy::OnRenderPassBegins()
{
    m_isRenderPassResuming = false;
}

void BreakNodeCameraRenderStrategy::OnRenderPassResumes()
{
    m_isRenderPassResuming = true;
}

void BreakNodeCameraRenderStrategy::AddBreakNode(const Node* node)
{
    static_cast<void>(m_breakNodeList.Append(const_cast<Node*>(node)));
}

void BreakNodeCameraRenderStrategy::RemoveBreakNode(const Node* node)
{
    static_cast<void>(m_breakNodeList.Remove(const_cast<Node*>(node)));
}
} // namespace Candera

