//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_NODE_CLONE_STRATEGY_H)
#define CANDERA_NODE_CLONE_STRATEGY_H

#include <Candera/EngineBase/Cloning/TreeCloneStrategy.h>
#include <Candera/EngineBase/Cloning/SharedObjectCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

// Forward declarations.
class Node;
class Camera;
class CompositeGroup;
class LodNode;
class ReflectionCamera;
class Scene;
class StereoCamera;
class Appearance;
class Material;
class RenderMode;
class Texture;
class AbstractShaderParamSetter;
class Projection;

// Types of strategies for cloning nodes.
typedef TreeCloneStrategy<Node, Node> NodeCloneStrategy;
typedef TreeCloneStrategy<Camera, Node> CameraCloneStrategy;
typedef TreeCloneStrategy<CompositeGroup, Node> CompositeGroupCloneStrategy;
typedef TreeCloneStrategy<LodNode, Node> LodNodeCloneStrategy;
typedef TreeCloneStrategy<ReflectionCamera, Node> ReflectionCameraCloneStrategy;
typedef TreeCloneStrategy<Scene, Node> SceneCloneStrategy;
typedef TreeCloneStrategy<StereoCamera, Node> StereoCameraCloneStrategy;

// Types of strategies for cloning shared objects.
typedef SharedObjectCloneStrategy<Appearance, Node> AppearanceCloneStrategy;
typedef SharedObjectCloneStrategy<Material, Node> MaterialCloneStrategy;
typedef SharedObjectCloneStrategy<RenderMode, Node> RenderModeCloneStrategy;
typedef SharedObjectCloneStrategy<Texture, Node> TextureCloneStrategy;
typedef SharedObjectCloneStrategy<AbstractShaderParamSetter, Node> ShaderParamSetterCloneStrategy;
typedef SharedObjectCloneStrategy<Projection, Node> ProjectionCloneStrategy;

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_NODE_CLONE_STRATEGY_H
