//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_TREE_CLONER_H)
#define CANDERA_DEEP_TREE_CLONER_H

#include <Candera/Environment.h>
#include <Candera/Engine3D/Cloning/TreeCloner.h>
#include <Candera/Engine3D/Cloning/DeepNodeCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

//forward declarations
class Node;

/**
 * @brief This class creates deep clones scene subtrees.
 *
 * It is a convenience wrapper of TreeCloner, that uses a DeepNodeCloneStrategy.
 * Shared objects are shared between subsequent calls to CreateClone.
 * Destroy cloner, or call Clear to avoid sharing.
 */
class DeepTreeCloner {
public:
    /**
     * Constructor.
     */
    DeepTreeCloner();

    /**
     * Create a deep clone of the given tree.
     * @param root Root of the source tree.
     * @return a clone of the given tree.
     */
    Node* CreateClone(const Node& root);

    /**
     * Clear the maps of shared objects.
     */
    void Clear() { m_nodeCloneStrategy.Clear(); }

    /**
     * Retrieve the DeepNodeCloneStrategy object. This gives the possibility
     * of replacing sub strategies.
     * @return Reference of the inner strategy.
     */
    DeepNodeCloneStrategy& GetNodeCloneStrategy() { return m_nodeCloneStrategy; }
private:
    FEATSTD_MAKE_CLASS_UNCOPYABLE(DeepTreeCloner);

    TreeCloner m_treeCloner;
    DeepNodeCloneStrategy m_nodeCloneStrategy;
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_TREE_CLONER_H
