//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "DeepStereoCameraCloneStrategy.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/Core/StereoCamera.h>
#include <Candera/Engine3D/Cloning/TreeMatch.h>

namespace Candera {

using namespace Diagnostics;

FEATSTD_LOG_SET_REALM(LogRealm::CanderaEngine3D);

void DeepStereoCameraCloneStrategy::Execute(const Pair& current, const RootPair& root)
{
    if ((current.source == 0) || (current.clone == 0)) {
        return;
    }

    Node* leftEyeClone = TreeMatch::Find(
            current.source->GetLeftEye(),
            root.source,
            root.clone);
    bool setEyeResult = current.clone->SetLeftEye(Dynamic_Cast<Camera*>(leftEyeClone));

    Node* rightEyeClone = TreeMatch::Find(
            current.source->GetRightEye(),
            root.source,
            root.clone);
    setEyeResult = setEyeResult && current.clone->SetRightEye(Dynamic_Cast<Camera*>(rightEyeClone));
    if (!setEyeResult) {
        FEATSTD_LOG_ERROR("Setting eyes to clone failed.");
    }
}


} // namespace Candera
