//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_REFLECTION_CAMERA_CLONE_STRATEGY_H)
#define CANDERA_DEEP_REFLECTION_CAMERA_CLONE_STRATEGY_H

#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepCameraCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

//forward declarations
class Node;

/**
 * @brief This is the default clone strategy for deep cloning reflection 
 * cameras. See DeepNodeCloneStrategy for rules.
 */
class DeepReflectionCameraCloneStrategy : public ReflectionCameraCloneStrategy{
public:
    // Implement pure function from ReflectionCameraCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;

    // Implement pure function from ReflectionCameraCloneStrategy.
    virtual void Clear() override { m_cameraCloneStrategy.Clear(); }
private:

    DeepCameraCloneStrategy m_cameraCloneStrategy;
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_REFLECTION_CAMERA_CLONE_STRATEGY_H
