//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_NODE_CLONE_STRATEGY_H)
#define CANDERA_DEEP_NODE_CLONE_STRATEGY_H

#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepAppearanceCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepCameraCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepCompositeGroupCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepLodNodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepReflectionCameraCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepSceneCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepStereoCameraCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

//forward declarations
class Node;

/**
 * @brief This is the default clone strategy for deep cloning.
 *
 * Cloning respects the following rules:
 *  - all shared resources are deep cloned as long as they are not device
 *      objects; shared resources in the destination are shared in the same
 *      pattern as in the source tree.
 *  - node references are rebuilt as long as source references are found as
 *      descendants of the source root; descendants are mapped to the
 *      destination tree.
 */
class DeepNodeCloneStrategy : public NodeCloneStrategy
{
public:
    // Implement pure virtual functions of NodeCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;
    virtual void Clear() override;

private:
    DeepAppearanceCloneStrategy m_appearance;
    DeepCameraCloneStrategy m_camera;
    DeepCompositeGroupCloneStrategy m_compositeGroup;
    DeepLodNodeCloneStrategy m_lodNode;
    DeepReflectionCameraCloneStrategy m_reflectionCamera;
    DeepSceneCloneStrategy m_scene;
    DeepStereoCameraCloneStrategy m_stereoCamera;
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_NODE_CLONE_STRATEGY_H
