//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_LOD_NODE_CLONE_STRATEGY_H)
#define CANDERA_DEEP_LOD_NODE_CLONE_STRATEGY_H

#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>
#include <Candera/Engine3D/Cloning/DeepCameraCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

//forward declarations
class Node;

/**
 * @brief This is the default clone strategy for deep cloning lod nodes.
 * See DeepNodeCloneStrategy for rules.
 */
class DeepLodNodeCloneStrategy : public LodNodeCloneStrategy{
public:
    // Implement pure function from LodNodeCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;

    // Implement pure function from LodNodeCloneStrategy.
    virtual void Clear() override {}
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_LOD_NODE_CLONE_STRATEGY_H
