//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_CAMERA_CLONE_STRATEGY_H)
#define CANDERA_DEEP_CAMERA_CLONE_STRATEGY_H

#include <Candera/Engine3D/Core/Projection.h>

#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>
#include <Candera/EngineBase/Cloning/MappedSharedObjectCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

//forward declarations
class Node;

/**
 * @brief This is the default clone strategy for deep cloning cameras.
 * See DeepNodeCloneStrategy for rules.
 */
class DeepCameraCloneStrategy : public CameraCloneStrategy{
public:    
    // Implement pure function from CameraCloneStrategy.
    virtual void Execute(const Pair& current, const RootPair& root) override;

    //Implements pure virtual function in CameraCloneStrategy.
    virtual void Clear() override { m_projection.Clear(); }

private:
    MappedSharedObjectCloneStrategy<Projection, Node> m_projection;
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_CAMERA_CLONE_STRATEGY_H
