//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DEEP_APPEARANCE_CLONE_STRATEGY_H)
#define CANDERA_DEEP_APPEARANCE_CLONE_STRATEGY_H

#include <Candera/Engine3D/Core/Appearance.h>
#include <Candera/Engine3D/Core/Material.h>
#include <Candera/Engine3D/Core/RenderMode.h>
#include <Candera/Engine3D/Core/Texture.h>
#include <Candera/Engine3D/ShaderParamSetters/AbstractShaderParamSetter.h>
#include <Candera/Engine3D/Cloning/NodeCloneStrategy.h>
#include <Candera/EngineBase/Cloning/MappedSharedObjectCloneStrategy.h>

namespace Candera {

/** @addtogroup Cloning3D
 *  @{
 */

//forward declarations
class Node;

/**
 * @brief This is the default clone strategy for deep cloning of appearances.
 *
 * This is a decorator of MappedSharedObjectCloneStrategy, that additionally
 * maps Materials, RenderModes, Textures and SharedParamSetters to shared
 * clones of the originals, instead of simply referencing originals.
 * Strategies for Materials, RenderModes, Textures and SharedParamSetters may
 * be replaced.
 */
class DeepAppearanceCloneStrategy : public AppearanceCloneStrategy {
public:
    // Implement pure function from AppearanceCloneStrategy.
    virtual Result Clone(const SharedPointer& source, 
        const NodeCloneStrategy::Pair& root) override;

    // Implement pure function from AppearanceCloneStrategy.
    virtual void Clear() override;

private:
    MappedSharedObjectCloneStrategy<Appearance, Node> m_apperanceMap;
    MappedSharedObjectCloneStrategy<Material, Node> m_material;
    MappedSharedObjectCloneStrategy<RenderMode, Node> m_renderMode;
    MappedSharedObjectCloneStrategy<Texture, Node> m_texture;
    MappedSharedObjectCloneStrategy<AbstractShaderParamSetter, Node> m_shaderParamSetter;
};

/** @} */ // end of Cloning3D

} // namespace Candera


#endif  // CANDERA_DEEP_APPEARANCE_CLONE_STRATEGY_H
