//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TranslateNodeRelativePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

        namespace {
            Vector3 TranslationV3Getter(const Node& n)
            {
                return n.GetPosition();
            }

            void TranslationV3Setter(Node& n, const Vector3& v3)
            {
                n.SetPosition(v3);
            }
        }

        FEATSTD_RTTI_DEFINITION(TranslateNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(TranslateXNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(TranslateYNodeRelativePropertySetter, NodeRelativePropertySetter)
        FEATSTD_RTTI_DEFINITION(TranslateZNodeRelativePropertySetter, NodeRelativePropertySetter)

        TranslateNodeRelativePropertySetter::SharedPointer TranslateNodeRelativePropertySetter::Create()
        {
            return TranslateNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(TranslateNodeRelativePropertySetter));
        }

        void TranslateNodeRelativePropertySetter::Set(const Float* value)
        {
            FEATSTD_LINT_CURRENT_SCOPE(446, "Violates MISRA C++ 2008 Required Rule 6-5-3: Only getter, no side effect")
            Float resultingValue[3] = { value[0] + m_position.GetX(),
                                        value[1] + m_position.GetY(),
                                        value[2] + m_position.GetZ()
                                      };

            SetVector3Property<TranslationV3Getter, TranslationV3Setter, XYZ_AxisSelector>(GetNode(), &resultingValue[0]);
        }

        void TranslateNodeRelativePropertySetter::Initialize()
        {
            m_position = (GetNode() != 0) ? GetNode()->GetPosition() : Vector3(0.0F, 0.0F, 0.0F);
        }

        TranslateXNodeRelativePropertySetter::SharedPointer TranslateXNodeRelativePropertySetter::Create()
        {
            return TranslateXNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(TranslateXNodeRelativePropertySetter));
        }

        void TranslateXNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] + m_positionX;
            SetVector3Property<TranslationV3Getter, TranslationV3Setter, X_AxisSelector>(GetNode(), &resultingValue);
        }

        void TranslateXNodeRelativePropertySetter::Initialize()
        {
            m_positionX = (GetNode() != 0) ? GetNode()->GetPosition().GetX() : 0.0F;
        }

        TranslateYNodeRelativePropertySetter::SharedPointer TranslateYNodeRelativePropertySetter::Create()
        {
            return TranslateYNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(TranslateYNodeRelativePropertySetter));
        }

        void TranslateYNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] + m_positionY;
            SetVector3Property<TranslationV3Getter, TranslationV3Setter, Y_AxisSelector>(GetNode(), &resultingValue);
        }

        void TranslateYNodeRelativePropertySetter::Initialize()
        {
            m_positionY = (GetNode() != 0) ? GetNode()->GetPosition().GetY() : 0.0F;
        }

        TranslateZNodeRelativePropertySetter::SharedPointer TranslateZNodeRelativePropertySetter::Create()
        {
            return TranslateZNodeRelativePropertySetter::SharedPointer(CANDERA_NEW(TranslateZNodeRelativePropertySetter));
        }

        void TranslateZNodeRelativePropertySetter::Set(const Float* value)
        {
            Float resultingValue = value[0] + m_positionZ;
            SetVector3Property<TranslationV3Getter, TranslationV3Setter, Z_AxisSelector>(GetNode(), &resultingValue);
        }

        void TranslateZNodeRelativePropertySetter::Initialize()
        {
            m_positionZ = (GetNode() != 0) ? GetNode()->GetPosition().GetZ() : 0.0F;
        }

    }
}
