//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_TranslateNodePropertySetter_H)
#define CANDERA_TranslateNodePropertySetter_H

#include <Candera/Engine3D/AnimationPropertySetters/NodePropertySetter.h>

namespace Candera {

    namespace Animation {

/** @addtogroup AnimationPropertySetters3D
 *  @{
 */

/** @brief A PropertySetter that sets the Translation, XYZ of a Node. */
class TranslateNodePropertySetter : public NodePropertySetter {

    FEATSTD_TYPEDEF_BASE(NodePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(TranslateNodePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Translation, XYZ of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;
};

/** @brief A PropertySetter that sets the Translation, X of a Node. */
class TranslateXNodePropertySetter : public NodePropertySetter {

    FEATSTD_TYPEDEF_BASE(NodePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(TranslateXNodePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Translation, X of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;

};

/** @brief A PropertySetter that sets the Translation, Y of a Node. */
class TranslateYNodePropertySetter : public NodePropertySetter {

    FEATSTD_TYPEDEF_BASE(NodePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(TranslateYNodePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Translation, Y of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;

};

/** @brief A PropertySetter that sets the Translation, Z of a Node. */
class TranslateZNodePropertySetter : public NodePropertySetter {

    FEATSTD_TYPEDEF_BASE(NodePropertySetter);

public:
    FEATSTD_RTTI_DECLARATION();

    FEATSTD_TYPEDEF_SHARED_POINTER(TranslateZNodePropertySetter);

    FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

    // override (AnimationPropertySetter)
    /**
     *  A PropertySetter that sets the Translation, Z of a Node.
     *  @param value The value that is assigned.
     */
    virtual void Set(const Float* value) override;

};

/** @} */ // end of AnimationPropertySetters3D

    }
}
#endif
