//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TranslateNodePropertySetter.h"
#include <Candera/Engine3D/Core/Node.h>
#include <Candera/Engine3D/AnimationPropertySetters/Vector3PropertySetterUtil.h>

CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1025, Lint may be in error)
CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(1703, Lint may be in error)

namespace Candera {
    namespace Animation {

namespace {
Vector3 TranslationV3Getter(const Node& n)
{
    return n.GetPosition();
}

void TranslationV3Setter(Node& n, const Vector3& v3)
{
    n.SetPosition(v3);
}
}
FEATSTD_RTTI_DEFINITION(TranslateNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(TranslateXNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(TranslateYNodePropertySetter, NodePropertySetter)
FEATSTD_RTTI_DEFINITION(TranslateZNodePropertySetter, NodePropertySetter)

TranslateNodePropertySetter::SharedPointer TranslateNodePropertySetter::Create()
{
    return TranslateNodePropertySetter::SharedPointer(CANDERA_NEW(TranslateNodePropertySetter));
}

void TranslateNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<TranslationV3Getter, TranslationV3Setter, XYZ_AxisSelector>(GetNode(), value);
}

TranslateXNodePropertySetter::SharedPointer TranslateXNodePropertySetter::Create()
{
    return TranslateXNodePropertySetter::SharedPointer(CANDERA_NEW(TranslateXNodePropertySetter));
}

void TranslateXNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<TranslationV3Getter, TranslationV3Setter, X_AxisSelector>(GetNode(), value);
}

TranslateYNodePropertySetter::SharedPointer TranslateYNodePropertySetter::Create()
{
    return TranslateYNodePropertySetter::SharedPointer(CANDERA_NEW(TranslateYNodePropertySetter));
}

void TranslateYNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<TranslationV3Getter, TranslationV3Setter, Y_AxisSelector>(GetNode(), value);
}

TranslateZNodePropertySetter::SharedPointer TranslateZNodePropertySetter::Create()
{
    return TranslateZNodePropertySetter::SharedPointer(CANDERA_NEW(TranslateZNodePropertySetter));
}

void TranslateZNodePropertySetter::Set(const Float* value)
{
    SetVector3Property<TranslationV3Getter, TranslationV3Setter, Z_AxisSelector>(GetNode(), value);
}



    }
}
